/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.protocol;

import java.io.IOException;
import org.testifyproject.apache.http.HttpException;
import org.testifyproject.apache.http.HttpResponse;
import org.testifyproject.apache.http.HttpResponseInterceptor;
import org.testifyproject.apache.http.annotation.ThreadSafe;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.protocol.HttpDateGenerator;
import org.testifyproject.apache.http.util.Args;

@ThreadSafe
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

