/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import java.util.Enumeration;
import org.testifyproject.bouncycastle.asn1.ASN1EncodableVector;
import org.testifyproject.bouncycastle.asn1.ASN1Integer;
import org.testifyproject.bouncycastle.asn1.ASN1Object;
import org.testifyproject.bouncycastle.asn1.ASN1OctetString;
import org.testifyproject.bouncycastle.asn1.ASN1Primitive;
import org.testifyproject.bouncycastle.asn1.ASN1Sequence;
import org.testifyproject.bouncycastle.asn1.DERNull;
import org.testifyproject.bouncycastle.asn1.DEROctetString;
import org.testifyproject.bouncycastle.asn1.DERSequence;
import org.testifyproject.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PBKDF2Params
extends ASN1Object {
    private static final AlgorithmIdentifier algid_hmacWithSHA1 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private ASN1OctetString octStr;
    private ASN1Integer iterationCount;
    private ASN1Integer keyLength;
    private AlgorithmIdentifier prf;

    public static PBKDF2Params getInstance(Object object) {
        if (object instanceof PBKDF2Params) {
            return (PBKDF2Params)object;
        }
        if (object != null) {
            return new PBKDF2Params(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PBKDF2Params(byte[] byArray, int n) {
        this.octStr = new DEROctetString(byArray);
        this.iterationCount = new ASN1Integer(n);
    }

    public PBKDF2Params(byte[] byArray, int n, int n2) {
        this(byArray, n);
        this.keyLength = new ASN1Integer(n2);
    }

    public PBKDF2Params(byte[] byArray, int n, int n2, AlgorithmIdentifier algorithmIdentifier) {
        this(byArray, n);
        this.keyLength = new ASN1Integer(n2);
        this.prf = algorithmIdentifier;
    }

    public PBKDF2Params(byte[] byArray, int n, AlgorithmIdentifier algorithmIdentifier) {
        this(byArray, n);
        this.prf = algorithmIdentifier;
    }

    private PBKDF2Params(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.octStr = (ASN1OctetString)enumeration.nextElement();
        this.iterationCount = (ASN1Integer)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof ASN1Integer) {
                this.keyLength = ASN1Integer.getInstance(object);
                object = enumeration.hasMoreElements() ? enumeration.nextElement() : null;
            } else {
                this.keyLength = null;
            }
            if (object != null) {
                this.prf = AlgorithmIdentifier.getInstance(object);
            }
        }
    }

    public byte[] getSalt() {
        return this.octStr.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.iterationCount.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.keyLength != null) {
            return this.keyLength.getValue();
        }
        return null;
    }

    public boolean isDefaultPrf() {
        return this.prf == null || this.prf.equals(algid_hmacWithSHA1);
    }

    public AlgorithmIdentifier getPrf() {
        if (this.prf != null) {
            return this.prf;
        }
        return algid_hmacWithSHA1;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.octStr);
        aSN1EncodableVector.add(this.iterationCount);
        if (this.keyLength != null) {
            aSN1EncodableVector.add(this.keyLength);
        }
        if (this.prf != null && !this.prf.equals(algid_hmacWithSHA1)) {
            aSN1EncodableVector.add(this.prf);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

