/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.cert.crmf;

import java.io.IOException;
import org.testifyproject.bouncycastle.asn1.cms.EnvelopedData;
import org.testifyproject.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import org.testifyproject.bouncycastle.asn1.crmf.EncKeyWithID;
import org.testifyproject.bouncycastle.asn1.crmf.EncryptedKey;
import org.testifyproject.bouncycastle.asn1.crmf.PKIArchiveOptions;
import org.testifyproject.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.testifyproject.bouncycastle.asn1.x509.GeneralName;
import org.testifyproject.bouncycastle.cert.crmf.PKIArchiveControl;
import org.testifyproject.bouncycastle.cms.CMSEnvelopedData;
import org.testifyproject.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.testifyproject.bouncycastle.cms.CMSException;
import org.testifyproject.bouncycastle.cms.CMSProcessableByteArray;
import org.testifyproject.bouncycastle.cms.RecipientInfoGenerator;
import org.testifyproject.bouncycastle.operator.OutputEncryptor;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

