/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.testifyproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testifyproject.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.testifyproject.bouncycastle.cms.CMSException;
import org.testifyproject.bouncycastle.cms.CMSReadable;
import org.testifyproject.bouncycastle.cms.CMSTypedData;
import org.testifyproject.bouncycastle.util.Arrays;

public class CMSProcessableByteArray
implements CMSTypedData,
CMSReadable {
    private final ASN1ObjectIdentifier type;
    private final byte[] bytes;

    public CMSProcessableByteArray(byte[] byArray) {
        this(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), byArray);
    }

    public CMSProcessableByteArray(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        this.type = aSN1ObjectIdentifier;
        this.bytes = byArray;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        outputStream.write(this.bytes);
    }

    public Object getContent() {
        return Arrays.clone(this.bytes);
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }
}

