/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.cms.bc;

import org.testifyproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testifyproject.bouncycastle.asn1.ASN1OctetString;
import org.testifyproject.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.cms.CMSException;
import org.testifyproject.bouncycastle.cms.PasswordRecipientInfoGenerator;
import org.testifyproject.bouncycastle.cms.bc.CMSUtils;
import org.testifyproject.bouncycastle.cms.bc.EnvelopedDataHelper;
import org.testifyproject.bouncycastle.crypto.Wrapper;
import org.testifyproject.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.testifyproject.bouncycastle.crypto.params.KeyParameter;
import org.testifyproject.bouncycastle.crypto.params.ParametersWithIV;
import org.testifyproject.bouncycastle.operator.GenericKey;

public class BcPasswordRecipientInfoGenerator
extends PasswordRecipientInfoGenerator {
    public BcPasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray) {
        super(aSN1ObjectIdentifier, cArray);
    }

    protected byte[] calculateDerivedKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, int n) throws CMSException {
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(algorithmIdentifier.getParameters());
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        pKCS5S2ParametersGenerator.init(byArray, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
        return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n)).getKey();
    }

    public byte[] generateEncryptedBytes(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, GenericKey genericKey) throws CMSException {
        byte[] byArray2 = ((KeyParameter)CMSUtils.getBcKey(genericKey)).getKey();
        Wrapper wrapper = EnvelopedDataHelper.createRFC3211Wrapper(algorithmIdentifier.getAlgorithm());
        wrapper.init(true, new ParametersWithIV(new KeyParameter(byArray), ASN1OctetString.getInstance(algorithmIdentifier.getParameters()).getOctets()));
        return wrapper.wrap(byArray2, 0, byArray2.length);
    }
}

