/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.crypto.engines;

import java.math.BigInteger;

public class CramerShoupCiphertext {
    BigInteger u1;
    BigInteger u2;
    BigInteger e;
    BigInteger v;

    public CramerShoupCiphertext() {
    }

    public CramerShoupCiphertext(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.u1 = bigInteger;
        this.u2 = bigInteger2;
        this.e = bigInteger3;
        this.v = bigInteger4;
    }

    public CramerShoupCiphertext(byte[] byArray) {
        int n = 0;
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n, byArray2, 0, 4);
        int n2 = this.byteArrayToInt(byArray2);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n += 4, byArray3, 0, n2);
        this.u1 = new BigInteger(byArray3);
        System.arraycopy(byArray, n += n2, byArray2, 0, 4);
        n2 = this.byteArrayToInt(byArray2);
        byArray3 = new byte[n2];
        System.arraycopy(byArray, n += 4, byArray3, 0, n2);
        this.u2 = new BigInteger(byArray3);
        System.arraycopy(byArray, n += n2, byArray2, 0, 4);
        n2 = this.byteArrayToInt(byArray2);
        byArray3 = new byte[n2];
        System.arraycopy(byArray, n += 4, byArray3, 0, n2);
        this.e = new BigInteger(byArray3);
        System.arraycopy(byArray, n += n2, byArray2, 0, 4);
        n2 = this.byteArrayToInt(byArray2);
        byArray3 = new byte[n2];
        System.arraycopy(byArray, n += 4, byArray3, 0, n2);
        n += n2;
        this.v = new BigInteger(byArray3);
    }

    public BigInteger getU1() {
        return this.u1;
    }

    public void setU1(BigInteger bigInteger) {
        this.u1 = bigInteger;
    }

    public BigInteger getU2() {
        return this.u2;
    }

    public void setU2(BigInteger bigInteger) {
        this.u2 = bigInteger;
    }

    public BigInteger getE() {
        return this.e;
    }

    public void setE(BigInteger bigInteger) {
        this.e = bigInteger;
    }

    public BigInteger getV() {
        return this.v;
    }

    public void setV(BigInteger bigInteger) {
        this.v = bigInteger;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("u1: " + this.u1.toString());
        stringBuffer.append("\nu2: " + this.u2.toString());
        stringBuffer.append("\ne: " + this.e.toString());
        stringBuffer.append("\nv: " + this.v.toString());
        return stringBuffer.toString();
    }

    public byte[] toByteArray() {
        byte[] byArray = this.u1.toByteArray();
        int n = byArray.length;
        byte[] byArray2 = this.u2.toByteArray();
        int n2 = byArray2.length;
        byte[] byArray3 = this.e.toByteArray();
        int n3 = byArray3.length;
        byte[] byArray4 = this.v.toByteArray();
        int n4 = byArray4.length;
        int n5 = 0;
        byte[] byArray5 = new byte[n + n2 + n3 + n4 + 16];
        System.arraycopy(this.intToByteArray(n), 0, byArray5, 0, 4);
        System.arraycopy(byArray, 0, byArray5, n5 += 4, n);
        System.arraycopy(this.intToByteArray(n2), 0, byArray5, n5 += n, 4);
        System.arraycopy(byArray2, 0, byArray5, n5 += 4, n2);
        System.arraycopy(this.intToByteArray(n3), 0, byArray5, n5 += n2, 4);
        System.arraycopy(byArray3, 0, byArray5, n5 += 4, n3);
        System.arraycopy(this.intToByteArray(n4), 0, byArray5, n5 += n3, 4);
        System.arraycopy(byArray4, 0, byArray5, n5 += 4, n4);
        return byArray5;
    }

    private byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[3 - i] = (byte)(n >>> i * 8);
        }
        return byArray;
    }

    private int byteArrayToInt(byte[] byArray) {
        if (byArray.length != 4) {
            return -1;
        }
        int n = 0;
        for (int i = 3; i >= 0; --i) {
            n += byArray[i] << (3 - i) * 8;
        }
        return n;
    }
}

