/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.testifyproject.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.testifyproject.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.testifyproject.bouncycastle.crypto.KeyGenerationParameters;
import org.testifyproject.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import org.testifyproject.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.testifyproject.bouncycastle.crypto.params.DHParameters;
import org.testifyproject.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.testifyproject.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

