/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.crypto.tls;

import java.io.IOException;
import org.testifyproject.bouncycastle.crypto.modes.AEADBlockCipher;
import org.testifyproject.bouncycastle.crypto.params.AEADParameters;
import org.testifyproject.bouncycastle.crypto.params.KeyParameter;
import org.testifyproject.bouncycastle.crypto.tls.TlsCipher;
import org.testifyproject.bouncycastle.crypto.tls.TlsContext;
import org.testifyproject.bouncycastle.crypto.tls.TlsFatalAlert;
import org.testifyproject.bouncycastle.crypto.tls.TlsUtils;
import org.testifyproject.bouncycastle.util.Arrays;

public class TlsAEADCipher
implements TlsCipher {
    protected TlsContext context;
    protected int macSize;
    protected int nonce_explicit_length;
    protected AEADBlockCipher encryptCipher;
    protected AEADBlockCipher decryptCipher;
    protected byte[] encryptImplicitNonce;
    protected byte[] decryptImplicitNonce;

    public TlsAEADCipher(TlsContext tlsContext, AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, int n, int n2) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        if (!TlsUtils.isTLSv12(tlsContext)) {
            throw new TlsFatalAlert(80);
        }
        this.context = tlsContext;
        this.macSize = n2;
        this.nonce_explicit_length = 8;
        int n3 = 4;
        int n4 = 2 * n + 2 * n3;
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, n4);
        int n5 = 0;
        KeyParameter keyParameter3 = new KeyParameter(byArray, n5, n);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n5 += n, n);
        byte[] byArray2 = Arrays.copyOfRange(byArray, n5 += n, n5 + n3);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n5 += n3, n5 + n3);
        if ((n5 += n3) != n4) {
            throw new TlsFatalAlert(80);
        }
        if (tlsContext.isServer()) {
            this.encryptCipher = aEADBlockCipher2;
            this.decryptCipher = aEADBlockCipher;
            this.encryptImplicitNonce = byArray3;
            this.decryptImplicitNonce = byArray2;
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            this.encryptCipher = aEADBlockCipher;
            this.decryptCipher = aEADBlockCipher2;
            this.encryptImplicitNonce = byArray2;
            this.decryptImplicitNonce = byArray3;
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        byte[] byArray4 = new byte[n3 + this.nonce_explicit_length];
        this.encryptCipher.init(true, new AEADParameters(keyParameter2, 8 * n2, byArray4));
        this.decryptCipher.init(false, new AEADParameters(keyParameter, 8 * n2, byArray4));
    }

    public int getPlaintextLimit(int n) {
        return n - this.macSize - this.nonce_explicit_length;
    }

    public byte[] encodePlaintext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[this.encryptImplicitNonce.length + this.nonce_explicit_length];
        System.arraycopy(this.encryptImplicitNonce, 0, byArray2, 0, this.encryptImplicitNonce.length);
        TlsUtils.writeUint64(l, byArray2, this.encryptImplicitNonce.length);
        int n3 = n;
        int n4 = n2;
        int n5 = this.encryptCipher.getOutputSize(n4);
        byte[] byArray3 = new byte[this.nonce_explicit_length + n5];
        System.arraycopy(byArray2, this.encryptImplicitNonce.length, byArray3, 0, this.nonce_explicit_length);
        int n6 = this.nonce_explicit_length;
        byte[] byArray4 = this.getAdditionalData(l, s, n4);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray2, byArray4);
        try {
            this.encryptCipher.init(true, aEADParameters);
            n6 += this.encryptCipher.processBytes(byArray, n3, n4, byArray3, n6);
            n6 += this.encryptCipher.doFinal(byArray3, n6);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80);
        }
        if (n6 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    public byte[] decodeCiphertext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        if (this.getPlaintextLimit(n2) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray2 = new byte[this.decryptImplicitNonce.length + this.nonce_explicit_length];
        System.arraycopy(this.decryptImplicitNonce, 0, byArray2, 0, this.decryptImplicitNonce.length);
        System.arraycopy(byArray, n, byArray2, this.decryptImplicitNonce.length, this.nonce_explicit_length);
        int n3 = n + this.nonce_explicit_length;
        int n4 = n2 - this.nonce_explicit_length;
        int n5 = this.decryptCipher.getOutputSize(n4);
        byte[] byArray3 = new byte[n5];
        int n6 = 0;
        byte[] byArray4 = this.getAdditionalData(l, s, n5);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray2, byArray4);
        try {
            this.decryptCipher.init(false, aEADParameters);
            n6 += this.decryptCipher.processBytes(byArray, n3, n4, byArray3, n6);
            n6 += this.decryptCipher.doFinal(byArray3, n6);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(20);
        }
        if (n6 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    protected byte[] getAdditionalData(long l, short s, int n) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(l, byArray, 0);
        TlsUtils.writeUint8(s, byArray, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(n, byArray, 11);
        return byArray;
    }
}

