/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.testifyproject.bouncycastle.crypto.Digest;
import org.testifyproject.bouncycastle.crypto.Signer;
import org.testifyproject.bouncycastle.crypto.params.DHParameters;
import org.testifyproject.bouncycastle.crypto.tls.CombinedHash;
import org.testifyproject.bouncycastle.crypto.tls.DigestInputBuffer;
import org.testifyproject.bouncycastle.crypto.tls.DigitallySigned;
import org.testifyproject.bouncycastle.crypto.tls.SecurityParameters;
import org.testifyproject.bouncycastle.crypto.tls.ServerDHParams;
import org.testifyproject.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.testifyproject.bouncycastle.crypto.tls.SignerInputBuffer;
import org.testifyproject.bouncycastle.crypto.tls.TlsCredentials;
import org.testifyproject.bouncycastle.crypto.tls.TlsDHKeyExchange;
import org.testifyproject.bouncycastle.crypto.tls.TlsDHUtils;
import org.testifyproject.bouncycastle.crypto.tls.TlsFatalAlert;
import org.testifyproject.bouncycastle.crypto.tls.TlsSigner;
import org.testifyproject.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.testifyproject.bouncycastle.crypto.tls.TlsUtils;
import org.testifyproject.bouncycastle.util.io.TeeInputStream;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsDHEKeyExchange(int n, Vector vector, DHParameters dHParameters) {
        super(n, vector, dHParameters);
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(tlsCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)tlsCredentials;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        Digest digest;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm;
        if (this.dhParameters == null) {
            throw new TlsFatalAlert(80);
        }
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        this.dhAgreeServerPrivateKey = TlsDHUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.dhParameters, digestInputBuffer);
        if (TlsUtils.isTLSv12(this.context)) {
            signatureAndHashAlgorithm = this.serverCredentials.getSignatureAndHashAlgorithm();
            if (signatureAndHashAlgorithm == null) {
                throw new TlsFatalAlert(80);
            }
            digest = TlsUtils.createHash(signatureAndHashAlgorithm.getHash());
        } else {
            signatureAndHashAlgorithm = null;
            digest = new CombinedHash();
        }
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        digest.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        digest.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        digestInputBuffer.updateDigest(digest);
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        byte[] byArray2 = this.serverCredentials.generateCertificateSignature(byArray);
        DigitallySigned digitallySigned = new DigitallySigned(signatureAndHashAlgorithm, byArray2);
        digitallySigned.encode(digestInputBuffer);
        return digestInputBuffer.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer signerInputBuffer = new SignerInputBuffer();
        TeeInputStream teeInputStream = new TeeInputStream(inputStream, signerInputBuffer);
        ServerDHParams serverDHParams = ServerDHParams.parse(teeInputStream);
        DigitallySigned digitallySigned = DigitallySigned.parse(this.context, inputStream);
        Signer signer = this.initVerifyer(this.tlsSigner, digitallySigned.getAlgorithm(), securityParameters);
        signerInputBuffer.updateSigner(signer);
        if (!signer.verifySignature(digitallySigned.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.dhAgreeServerPublicKey = TlsDHUtils.validateDHPublicKey(serverDHParams.getPublicKey());
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm signatureAndHashAlgorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(signatureAndHashAlgorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

