/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.jcajce.provider.digest;

import org.testifyproject.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.testifyproject.bouncycastle.crypto.CipherKeyGenerator;
import org.testifyproject.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.testifyproject.bouncycastle.crypto.macs.HMac;
import org.testifyproject.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.testifyproject.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import org.testifyproject.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import org.testifyproject.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.testifyproject.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class RIPEMD128 {
    private RIPEMD128() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD128Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new RIPEMD128Digest((RIPEMD128Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new RIPEMD128Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD128", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD128.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.RIPEMD128", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd128, "RIPEMD128");
            this.addHMACAlgorithm(configurableProvider, "RIPEMD128", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }
}

