/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.openssl.jcajce;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.testifyproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testifyproject.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.testifyproject.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.testifyproject.bouncycastle.crypto.PBEParametersGenerator;
import org.testifyproject.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.testifyproject.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.testifyproject.bouncycastle.crypto.params.KeyParameter;
import org.testifyproject.bouncycastle.jcajce.util.JcaJceHelper;
import org.testifyproject.bouncycastle.openssl.EncryptionException;
import org.testifyproject.bouncycastle.openssl.PEMException;
import org.testifyproject.bouncycastle.util.Integers;

class PEMUtilities {
    private static final Map KEYSIZES = new HashMap();
    private static final Set PKCS5_SCHEME_1 = new HashSet();
    private static final Set PKCS5_SCHEME_2 = new HashSet();

    PEMUtilities() {
    }

    static int getKeySize(String string) {
        if (!KEYSIZES.containsKey(string)) {
            throw new IllegalStateException("no key size for algorithm: " + string);
        }
        return (Integer)KEYSIZES.get(string);
    }

    static boolean isPKCS5Scheme1(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return PKCS5_SCHEME_1.contains(aSN1ObjectIdentifier);
    }

    static boolean isPKCS5Scheme2(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return PKCS5_SCHEME_2.contains(aSN1ObjectIdentifier);
    }

    public static boolean isPKCS12(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return aSN1ObjectIdentifier.getId().startsWith(PKCSObjectIdentifiers.pkcs_12PbeIds.getId());
    }

    public static SecretKey generateSecretKeyForPKCS5Scheme2(String string, char[] cArray, byte[] byArray, int n) {
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray, n);
        return new SecretKeySpec(((KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(PEMUtilities.getKeySize(string))).getKey(), string);
    }

    static byte[] crypt(boolean bl, JcaJceHelper jcaJceHelper, byte[] byArray, char[] cArray, String string, byte[] byArray2) throws PEMException {
        SecretKey secretKey;
        String string2;
        AlgorithmParameterSpec algorithmParameterSpec = new IvParameterSpec(byArray2);
        String string3 = "CBC";
        String string4 = "PKCS5Padding";
        if (string.endsWith("-CFB")) {
            string3 = "CFB";
            string4 = "NoPadding";
        }
        if (string.endsWith("-ECB") || "DES-EDE".equals(string) || "DES-EDE3".equals(string)) {
            string3 = "ECB";
            algorithmParameterSpec = null;
        }
        if (string.endsWith("-OFB")) {
            string3 = "OFB";
            string4 = "NoPadding";
        }
        if (string.startsWith("DES-EDE")) {
            string2 = "DESede";
            boolean bl2 = !string.startsWith("DES-EDE3");
            secretKey = PEMUtilities.getKey(cArray, string2, 24, byArray2, bl2);
        } else if (string.startsWith("DES-")) {
            string2 = "DES";
            secretKey = PEMUtilities.getKey(cArray, string2, 8, byArray2);
        } else if (string.startsWith("BF-")) {
            string2 = "Blowfish";
            secretKey = PEMUtilities.getKey(cArray, string2, 16, byArray2);
        } else if (string.startsWith("RC2-")) {
            string2 = "RC2";
            int n = 128;
            if (string.startsWith("RC2-40-")) {
                n = 40;
            } else if (string.startsWith("RC2-64-")) {
                n = 64;
            }
            secretKey = PEMUtilities.getKey(cArray, string2, n / 8, byArray2);
            algorithmParameterSpec = algorithmParameterSpec == null ? new RC2ParameterSpec(n) : new RC2ParameterSpec(n, byArray2);
        } else if (string.startsWith("AES-")) {
            int n;
            string2 = "AES";
            byte[] byArray3 = byArray2;
            if (byArray3.length > 8) {
                byArray3 = new byte[8];
                System.arraycopy(byArray2, 0, byArray3, 0, 8);
            }
            if (string.startsWith("AES-128-")) {
                n = 128;
            } else if (string.startsWith("AES-192-")) {
                n = 192;
            } else if (string.startsWith("AES-256-")) {
                n = 256;
            } else {
                throw new EncryptionException("unknown AES encryption with private key");
            }
            secretKey = PEMUtilities.getKey(cArray, "AES", n / 8, byArray3);
        } else {
            throw new EncryptionException("unknown encryption with private key");
        }
        String string5 = string2 + "/" + string3 + "/" + string4;
        try {
            int n;
            Cipher cipher = jcaJceHelper.createCipher(string5);
            int n2 = n = bl ? 1 : 2;
            if (algorithmParameterSpec == null) {
                cipher.init(n, secretKey);
            } else {
                cipher.init(n, (Key)secretKey, algorithmParameterSpec);
            }
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new EncryptionException("exception using cipher - please check password and data.", (Throwable)exception);
        }
    }

    private static SecretKey getKey(char[] cArray, String string, int n, byte[] byArray) {
        return PEMUtilities.getKey(cArray, string, n, byArray, false);
    }

    private static SecretKey getKey(char[] cArray, String string, int n, byte[] byArray, boolean bl) {
        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
        openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray);
        KeyParameter keyParameter = (KeyParameter)openSSLPBEParametersGenerator.generateDerivedParameters(n * 8);
        byte[] byArray2 = keyParameter.getKey();
        if (bl && byArray2.length >= 24) {
            System.arraycopy(byArray2, 0, byArray2, 16, 8);
        }
        return new SecretKeySpec(byArray2, string);
    }

    static {
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC);
        PKCS5_SCHEME_2.add(PKCSObjectIdentifiers.id_PBES2);
        PKCS5_SCHEME_2.add(PKCSObjectIdentifiers.des_EDE3_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes128_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes192_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes256_CBC);
        KEYSIZES.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), Integers.valueOf(192));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), Integers.valueOf(128));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), Integers.valueOf(192));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), Integers.valueOf(256));
    }
}

