/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.operator.bc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.testifyproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testifyproject.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.testifyproject.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.testifyproject.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.testifyproject.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.testifyproject.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.crypto.ExtendedDigest;
import org.testifyproject.bouncycastle.crypto.digests.GOST3411Digest;
import org.testifyproject.bouncycastle.crypto.digests.MD2Digest;
import org.testifyproject.bouncycastle.crypto.digests.MD4Digest;
import org.testifyproject.bouncycastle.crypto.digests.MD5Digest;
import org.testifyproject.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.testifyproject.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.testifyproject.bouncycastle.crypto.digests.RIPEMD256Digest;
import org.testifyproject.bouncycastle.crypto.digests.SHA1Digest;
import org.testifyproject.bouncycastle.crypto.digests.SHA224Digest;
import org.testifyproject.bouncycastle.crypto.digests.SHA256Digest;
import org.testifyproject.bouncycastle.crypto.digests.SHA384Digest;
import org.testifyproject.bouncycastle.crypto.digests.SHA512Digest;
import org.testifyproject.bouncycastle.operator.OperatorCreationException;
import org.testifyproject.bouncycastle.operator.bc.BcDigestProvider;

public class BcDefaultDigestProvider
implements BcDigestProvider {
    private static final Map lookup = BcDefaultDigestProvider.createTable();
    public static final BcDigestProvider INSTANCE = new BcDefaultDigestProvider();

    private static Map createTable() {
        HashMap<ASN1ObjectIdentifier, BcDigestProvider> hashMap = new HashMap<ASN1ObjectIdentifier, BcDigestProvider>();
        hashMap.put(OIWObjectIdentifiers.idSHA1, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA1Digest();
            }
        });
        hashMap.put(NISTObjectIdentifiers.id_sha224, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA224Digest();
            }
        });
        hashMap.put(NISTObjectIdentifiers.id_sha256, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA256Digest();
            }
        });
        hashMap.put(NISTObjectIdentifiers.id_sha384, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA384Digest();
            }
        });
        hashMap.put(NISTObjectIdentifiers.id_sha512, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA512Digest();
            }
        });
        hashMap.put(PKCSObjectIdentifiers.md5, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new MD5Digest();
            }
        });
        hashMap.put(PKCSObjectIdentifiers.md4, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new MD4Digest();
            }
        });
        hashMap.put(PKCSObjectIdentifiers.md2, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new MD2Digest();
            }
        });
        hashMap.put(CryptoProObjectIdentifiers.gostR3411, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new GOST3411Digest();
            }
        });
        hashMap.put(TeleTrusTObjectIdentifiers.ripemd128, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new RIPEMD128Digest();
            }
        });
        hashMap.put(TeleTrusTObjectIdentifiers.ripemd160, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new RIPEMD160Digest();
            }
        });
        hashMap.put(TeleTrusTObjectIdentifiers.ripemd256, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new RIPEMD256Digest();
            }
        });
        return Collections.unmodifiableMap(hashMap);
    }

    private BcDefaultDigestProvider() {
    }

    public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        BcDigestProvider bcDigestProvider = (BcDigestProvider)lookup.get(algorithmIdentifier.getAlgorithm());
        if (bcDigestProvider == null) {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return bcDigestProvider.get(algorithmIdentifier);
    }
}

