/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.operator.bc;

import java.security.SecureRandom;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.crypto.Wrapper;
import org.testifyproject.bouncycastle.crypto.params.KeyParameter;
import org.testifyproject.bouncycastle.crypto.params.ParametersWithRandom;
import org.testifyproject.bouncycastle.operator.GenericKey;
import org.testifyproject.bouncycastle.operator.OperatorException;
import org.testifyproject.bouncycastle.operator.SymmetricKeyWrapper;
import org.testifyproject.bouncycastle.operator.bc.OperatorUtils;

public class BcSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, Wrapper wrapper, KeyParameter keyParameter) {
        super(algorithmIdentifier);
        this.wrapper = wrapper;
        this.wrappingKey = keyParameter;
    }

    public BcSymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
        if (this.random == null) {
            this.wrapper.init(true, this.wrappingKey);
        } else {
            this.wrapper.init(true, new ParametersWithRandom(this.wrappingKey, this.random));
        }
        return this.wrapper.wrap(byArray, 0, byArray.length);
    }
}

