/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.pqc.jcajce.provider.mceliece;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.testifyproject.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyPairGenerator;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McElieceKeyPairGenerator;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import org.testifyproject.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import org.testifyproject.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PrivateKey;
import org.testifyproject.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PublicKey;
import org.testifyproject.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import org.testifyproject.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import org.testifyproject.bouncycastle.pqc.jcajce.spec.ECCKeyGenParameterSpec;
import org.testifyproject.bouncycastle.pqc.jcajce.spec.McElieceCCA2ParameterSpec;

public abstract class McElieceKeyPairGeneratorSpi
extends KeyPairGenerator {
    public McElieceKeyPairGeneratorSpi(String string) {
        super(string);
    }

    public static class McEliece
    extends McElieceKeyPairGeneratorSpi {
        McElieceKeyPairGenerator kpg;

        public McEliece() {
            super("McEliece");
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.kpg = new McElieceKeyPairGenerator();
            super.initialize(algorithmParameterSpec);
            ECCKeyGenParameterSpec eCCKeyGenParameterSpec = (ECCKeyGenParameterSpec)algorithmParameterSpec;
            McElieceKeyGenerationParameters mcElieceKeyGenerationParameters = new McElieceKeyGenerationParameters(new SecureRandom(), new McElieceParameters(eCCKeyGenParameterSpec.getM(), eCCKeyGenParameterSpec.getT()));
            this.kpg.init(mcElieceKeyGenerationParameters);
        }

        public void initialize(int n, SecureRandom secureRandom) {
            ECCKeyGenParameterSpec eCCKeyGenParameterSpec = new ECCKeyGenParameterSpec();
            try {
                this.initialize(eCCKeyGenParameterSpec);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }

        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpg.generateKeyPair();
            McEliecePrivateKeyParameters mcEliecePrivateKeyParameters = (McEliecePrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            McEliecePublicKeyParameters mcEliecePublicKeyParameters = (McEliecePublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            return new KeyPair(new BCMcEliecePublicKey(mcEliecePublicKeyParameters), new BCMcEliecePrivateKey(mcEliecePrivateKeyParameters));
        }
    }

    public static class McElieceCCA2
    extends McElieceKeyPairGeneratorSpi {
        McElieceCCA2KeyPairGenerator kpg;

        public McElieceCCA2() {
            super("McElieceCCA-2");
        }

        public McElieceCCA2(String string) {
            super(string);
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.kpg = new McElieceCCA2KeyPairGenerator();
            super.initialize(algorithmParameterSpec);
            ECCKeyGenParameterSpec eCCKeyGenParameterSpec = (ECCKeyGenParameterSpec)algorithmParameterSpec;
            McElieceCCA2KeyGenerationParameters mcElieceCCA2KeyGenerationParameters = new McElieceCCA2KeyGenerationParameters(new SecureRandom(), new McElieceCCA2Parameters(eCCKeyGenParameterSpec.getM(), eCCKeyGenParameterSpec.getT()));
            this.kpg.init(mcElieceCCA2KeyGenerationParameters);
        }

        public void initialize(int n, SecureRandom secureRandom) {
            McElieceCCA2ParameterSpec mcElieceCCA2ParameterSpec = new McElieceCCA2ParameterSpec();
            try {
                this.initialize(mcElieceCCA2ParameterSpec);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }

        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpg.generateKeyPair();
            McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters = (McElieceCCA2PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters = (McElieceCCA2PublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            return new KeyPair(new BCMcElieceCCA2PublicKey(mcElieceCCA2PublicKeyParameters), new BCMcElieceCCA2PrivateKey(mcElieceCCA2PrivateKeyParameters));
        }
    }
}

