/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.fasterxml.jackson.databind.ext;

import java.io.IOException;
import java.lang.reflect.Type;
import org.testifyproject.fasterxml.jackson.core.JsonGenerationException;
import org.testifyproject.fasterxml.jackson.core.JsonGenerator;
import org.testifyproject.fasterxml.jackson.databind.JavaType;
import org.testifyproject.fasterxml.jackson.databind.JsonMappingException;
import org.testifyproject.fasterxml.jackson.databind.JsonNode;
import org.testifyproject.fasterxml.jackson.databind.SerializerProvider;
import org.testifyproject.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.testifyproject.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.testifyproject.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.testifyproject.w3c.dom.ls.DOMImplementationLS;
import org.testifyproject.w3c.dom.ls.LSSerializer;
import org.w3c.dom.Node;

public class DOMSerializer
extends StdSerializer<Node> {
    protected final DOMImplementationLS _domImpl;

    public DOMSerializer() {
        super(Node.class);
        DOMImplementationRegistry registry;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate DOMImplementationRegistry: " + e.getMessage(), e);
        }
        this._domImpl = (DOMImplementationLS)registry.getDOMImplementation("LS");
    }

    @Override
    public void serialize(Node value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._domImpl == null) {
            throw new IllegalStateException("Could not find DOM LS");
        }
        LSSerializer writer = this._domImpl.createLSSerializer();
        jgen.writeString(writer.writeToString(value));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectAnyFormat(typeHint);
        }
    }
}

