/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.gesellix.socketfactory.unix;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.testifyproject.apache.http.client.HttpClient;
import org.testifyproject.apache.http.conn.ConnectTimeoutException;
import org.testifyproject.apache.http.conn.scheme.Scheme;
import org.testifyproject.apache.http.params.HttpConnectionParams;
import org.testifyproject.apache.http.params.HttpParams;
import org.testifyproject.newsclub.net.unix.AFUNIXSocket;
import org.testifyproject.newsclub.net.unix.AFUNIXSocketAddress;
import org.testifyproject.spi.SocketFactory;

public class UnixSocketFactory
implements SocketFactory {
    private File socketFile;

    @Override
    public boolean supports(String scheme) {
        return "unix" == scheme;
    }

    @Override
    public String sanitize(String dockerHost) {
        return dockerHost.replaceAll("^unix://", "unix://localhost");
    }

    @Override
    public void configure(HttpClient httpClient, String dockerHost) {
        this.socketFile = new File(dockerHost.replaceAll("unix://localhost", ""));
        Scheme unixScheme = new Scheme("unix", 65535, this);
        httpClient.getConnectionManager().getSchemeRegistry().register(unixScheme);
    }

    @Override
    public Socket createSocket(HttpParams params) throws IOException {
        AFUNIXSocket socket = AFUNIXSocket.newInstance();
        return socket;
    }

    @Override
    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        int connTimeout = HttpConnectionParams.getConnectionTimeout(params);
        try {
            socket.connect(new AFUNIXSocketAddress(this.socketFile), connTimeout);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectTimeoutException("Connect to '" + this.socketFile + "' timed out");
        }
        return socket;
    }

    @Override
    public boolean isSecure(Socket sock) throws IllegalArgumentException {
        return false;
    }
}

