/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.api.model;

import java.io.IOException;
import java.util.Map;
import org.testifyproject.fasterxml.jackson.annotation.JsonIgnore;
import org.testifyproject.fasterxml.jackson.annotation.JsonProperty;
import org.testifyproject.fasterxml.jackson.core.JsonGenerator;
import org.testifyproject.fasterxml.jackson.core.JsonParser;
import org.testifyproject.fasterxml.jackson.core.JsonProcessingException;
import org.testifyproject.fasterxml.jackson.core.ObjectCodec;
import org.testifyproject.fasterxml.jackson.databind.DeserializationContext;
import org.testifyproject.fasterxml.jackson.databind.JsonDeserializer;
import org.testifyproject.fasterxml.jackson.databind.JsonNode;
import org.testifyproject.fasterxml.jackson.databind.JsonSerializer;
import org.testifyproject.fasterxml.jackson.databind.SerializerProvider;
import org.testifyproject.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.testifyproject.fasterxml.jackson.databind.annotation.JsonSerialize;

public class LogConfig {
    @JsonProperty(value="Type")
    public LoggingType type = null;
    @JsonProperty(value="Config")
    public Map<String, String> config;

    public LogConfig(LoggingType type, Map<String, String> config) {
        this.type = type;
        this.config = config;
    }

    public LogConfig(LoggingType type) {
        this(type, null);
    }

    public LogConfig() {
    }

    public LoggingType getType() {
        return this.type;
    }

    public LogConfig setType(LoggingType type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public Map<String, String> getConfig() {
        return this.config;
    }

    @JsonIgnore
    public LogConfig setConfig(Map<String, String> config) {
        this.config = config;
        return this;
    }

    @JsonDeserialize(using=Deserializer.class)
    @JsonSerialize(using=Serializer.class)
    public static enum LoggingType {
        DEFAULT("json-file"),
        JSON_FILE("json-file"),
        NONE("none"),
        SYSLOG("syslog"),
        JOURNALD("journald"),
        GELF("gelf"),
        FLUENTD("fluentd"),
        AWSLOGS("awslogs"),
        SPLUNK("splunk");

        private String type;

        private LoggingType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static final class Deserializer
        extends JsonDeserializer<LoggingType> {
            @Override
            public LoggingType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                ObjectCodec oc = jsonParser.getCodec();
                JsonNode node = (JsonNode)oc.readTree(jsonParser);
                for (LoggingType loggingType : LoggingType.values()) {
                    if (!loggingType.getType().equals(node.asText())) continue;
                    return loggingType;
                }
                throw new IllegalArgumentException("No enum constant " + LoggingType.class + "." + node.asText());
            }
        }

        public static final class Serializer
        extends JsonSerializer<LoggingType> {
            @Override
            public void serialize(LoggingType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(value.getType());
            }
        }
    }
}

