/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.core;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.testifyproject.github.dockerjava.api.DockerClient;
import org.testifyproject.github.dockerjava.api.command.AttachContainerCmd;
import org.testifyproject.github.dockerjava.api.command.AuthCmd;
import org.testifyproject.github.dockerjava.api.command.BuildImageCmd;
import org.testifyproject.github.dockerjava.api.command.CommitCmd;
import org.testifyproject.github.dockerjava.api.command.ConnectToNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.ContainerDiffCmd;
import org.testifyproject.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CopyFileFromContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CreateContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CreateImageCmd;
import org.testifyproject.github.dockerjava.api.command.CreateNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.CreateVolumeCmd;
import org.testifyproject.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.DockerCmdExecFactory;
import org.testifyproject.github.dockerjava.api.command.EventsCmd;
import org.testifyproject.github.dockerjava.api.command.ExecCreateCmd;
import org.testifyproject.github.dockerjava.api.command.ExecStartCmd;
import org.testifyproject.github.dockerjava.api.command.InfoCmd;
import org.testifyproject.github.dockerjava.api.command.InspectContainerCmd;
import org.testifyproject.github.dockerjava.api.command.InspectExecCmd;
import org.testifyproject.github.dockerjava.api.command.InspectImageCmd;
import org.testifyproject.github.dockerjava.api.command.InspectNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.InspectVolumeCmd;
import org.testifyproject.github.dockerjava.api.command.KillContainerCmd;
import org.testifyproject.github.dockerjava.api.command.ListContainersCmd;
import org.testifyproject.github.dockerjava.api.command.ListImagesCmd;
import org.testifyproject.github.dockerjava.api.command.ListNetworksCmd;
import org.testifyproject.github.dockerjava.api.command.ListVolumesCmd;
import org.testifyproject.github.dockerjava.api.command.LogContainerCmd;
import org.testifyproject.github.dockerjava.api.command.PauseContainerCmd;
import org.testifyproject.github.dockerjava.api.command.PingCmd;
import org.testifyproject.github.dockerjava.api.command.PullImageCmd;
import org.testifyproject.github.dockerjava.api.command.PushImageCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveContainerCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveImageCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveVolumeCmd;
import org.testifyproject.github.dockerjava.api.command.RenameContainerCmd;
import org.testifyproject.github.dockerjava.api.command.RestartContainerCmd;
import org.testifyproject.github.dockerjava.api.command.SaveImageCmd;
import org.testifyproject.github.dockerjava.api.command.SearchImagesCmd;
import org.testifyproject.github.dockerjava.api.command.StartContainerCmd;
import org.testifyproject.github.dockerjava.api.command.StatsCmd;
import org.testifyproject.github.dockerjava.api.command.StopContainerCmd;
import org.testifyproject.github.dockerjava.api.command.TagImageCmd;
import org.testifyproject.github.dockerjava.api.command.TopContainerCmd;
import org.testifyproject.github.dockerjava.api.command.UnpauseContainerCmd;
import org.testifyproject.github.dockerjava.api.command.UpdateContainerCmd;
import org.testifyproject.github.dockerjava.api.command.VersionCmd;
import org.testifyproject.github.dockerjava.api.command.WaitContainerCmd;
import org.testifyproject.github.dockerjava.api.model.AuthConfig;
import org.testifyproject.github.dockerjava.api.model.Identifier;
import org.testifyproject.github.dockerjava.core.DockerClientConfig;
import org.testifyproject.github.dockerjava.core.command.AttachContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.AuthCmdImpl;
import org.testifyproject.github.dockerjava.core.command.BuildImageCmdImpl;
import org.testifyproject.github.dockerjava.core.command.CommitCmdImpl;
import org.testifyproject.github.dockerjava.core.command.ConnectToNetworkCmdImpl;
import org.testifyproject.github.dockerjava.core.command.ContainerDiffCmdImpl;
import org.testifyproject.github.dockerjava.core.command.CopyArchiveFromContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.CopyArchiveToContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.CopyFileFromContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.CreateContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.CreateImageCmdImpl;
import org.testifyproject.github.dockerjava.core.command.CreateNetworkCmdImpl;
import org.testifyproject.github.dockerjava.core.command.CreateVolumeCmdImpl;
import org.testifyproject.github.dockerjava.core.command.DisconnectFromNetworkCmdImpl;
import org.testifyproject.github.dockerjava.core.command.EventsCmdImpl;
import org.testifyproject.github.dockerjava.core.command.ExecCreateCmdImpl;
import org.testifyproject.github.dockerjava.core.command.ExecStartCmdImpl;
import org.testifyproject.github.dockerjava.core.command.InfoCmdImpl;
import org.testifyproject.github.dockerjava.core.command.InpectNetworkCmdImpl;
import org.testifyproject.github.dockerjava.core.command.InspectContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.InspectExecCmdImpl;
import org.testifyproject.github.dockerjava.core.command.InspectImageCmdImpl;
import org.testifyproject.github.dockerjava.core.command.InspectVolumeCmdImpl;
import org.testifyproject.github.dockerjava.core.command.KillContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.ListContainersCmdImpl;
import org.testifyproject.github.dockerjava.core.command.ListImagesCmdImpl;
import org.testifyproject.github.dockerjava.core.command.ListNetworksCmdImpl;
import org.testifyproject.github.dockerjava.core.command.ListVolumesCmdImpl;
import org.testifyproject.github.dockerjava.core.command.LogContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.PauseContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.PingCmdImpl;
import org.testifyproject.github.dockerjava.core.command.PullImageCmdImpl;
import org.testifyproject.github.dockerjava.core.command.PushImageCmdImpl;
import org.testifyproject.github.dockerjava.core.command.RemoveContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.RemoveImageCmdImpl;
import org.testifyproject.github.dockerjava.core.command.RemoveNetworkCmdImpl;
import org.testifyproject.github.dockerjava.core.command.RemoveVolumeCmdImpl;
import org.testifyproject.github.dockerjava.core.command.RenameContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.RestartContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.SaveImageCmdImpl;
import org.testifyproject.github.dockerjava.core.command.SearchImagesCmdImpl;
import org.testifyproject.github.dockerjava.core.command.StartContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.StatsCmdImpl;
import org.testifyproject.github.dockerjava.core.command.StopContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.TagImageCmdImpl;
import org.testifyproject.github.dockerjava.core.command.TopContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.UnpauseContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.UpdateContainerCmdImpl;
import org.testifyproject.github.dockerjava.core.command.VersionCmdImpl;
import org.testifyproject.github.dockerjava.core.command.WaitContainerCmdImpl;
import org.testifyproject.google.common.base.Preconditions;

public class DockerClientImpl
implements Closeable,
DockerClient {
    private final DockerClientConfig dockerClientConfig;
    private DockerCmdExecFactory dockerCmdExecFactory;

    private DockerClientImpl() {
        this(DockerClientConfig.createDefaultConfigBuilder().build());
    }

    private DockerClientImpl(String serverUrl) {
        this(DockerClientImpl.configWithServerUrl(serverUrl));
    }

    private DockerClientImpl(DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(dockerClientConfig, "config was not specified");
        this.dockerClientConfig = dockerClientConfig;
    }

    private static DockerClientConfig configWithServerUrl(String serverUrl) {
        return DockerClientConfig.createDefaultConfigBuilder().withDockerHost(serverUrl).build();
    }

    public static DockerClientImpl getInstance() {
        return new DockerClientImpl();
    }

    public static DockerClientImpl getInstance(DockerClientConfig dockerClientConfig) {
        return new DockerClientImpl(dockerClientConfig);
    }

    public static DockerClientImpl getInstance(String serverUrl) {
        return new DockerClientImpl(serverUrl);
    }

    public DockerClientImpl withDockerCmdExecFactory(DockerCmdExecFactory dockerCmdExecFactory) {
        Preconditions.checkNotNull(dockerCmdExecFactory, "dockerCmdExecFactory was not specified");
        this.dockerCmdExecFactory = dockerCmdExecFactory;
        this.dockerCmdExecFactory.init(this.dockerClientConfig);
        return this;
    }

    private DockerCmdExecFactory getDockerCmdExecFactory() {
        Preconditions.checkNotNull(this.dockerCmdExecFactory, "dockerCmdExecFactory was not specified");
        return this.dockerCmdExecFactory;
    }

    @Override
    public AuthConfig authConfig() {
        Preconditions.checkNotNull(this.dockerClientConfig.getRegistryUsername(), "Configured username is null.");
        Preconditions.checkNotNull(this.dockerClientConfig.getRegistryUrl(), "Configured serverAddress is null.");
        return new AuthConfig().withUsername(this.dockerClientConfig.getRegistryUsername()).withPassword(this.dockerClientConfig.getRegistryPassword()).withEmail(this.dockerClientConfig.getRegistryEmail()).withRegistryAddress(this.dockerClientConfig.getRegistryUrl());
    }

    @Override
    public AuthCmd authCmd() {
        return new AuthCmdImpl(this.getDockerCmdExecFactory().createAuthCmdExec(), this.authConfig());
    }

    @Override
    public InfoCmd infoCmd() {
        return new InfoCmdImpl(this.getDockerCmdExecFactory().createInfoCmdExec());
    }

    @Override
    public PingCmd pingCmd() {
        return new PingCmdImpl(this.getDockerCmdExecFactory().createPingCmdExec());
    }

    @Override
    public VersionCmd versionCmd() {
        return new VersionCmdImpl(this.getDockerCmdExecFactory().createVersionCmdExec());
    }

    @Override
    public PullImageCmd pullImageCmd(String repository) {
        return new PullImageCmdImpl(this.getDockerCmdExecFactory().createPullImageCmdExec(), this.dockerClientConfig.effectiveAuthConfig(repository), repository);
    }

    @Override
    public PushImageCmd pushImageCmd(String name) {
        PushImageCmdImpl cmd = new PushImageCmdImpl(this.getDockerCmdExecFactory().createPushImageCmdExec(), name);
        AuthConfig cfg = this.dockerClientConfig.effectiveAuthConfig(name);
        if (cfg != null) {
            cmd.withAuthConfig(cfg);
        }
        return cmd;
    }

    @Override
    public PushImageCmd pushImageCmd(Identifier identifier) {
        AuthConfig cfg;
        PushImageCmd cmd = this.pushImageCmd(identifier.repository.name);
        if (identifier.tag.isPresent()) {
            cmd.withTag(identifier.tag.get());
        }
        if ((cfg = this.dockerClientConfig.effectiveAuthConfig(identifier.repository.name)) != null) {
            cmd.withAuthConfig(cfg);
        }
        return cmd;
    }

    @Override
    public SaveImageCmd saveImageCmd(String name) {
        return new SaveImageCmdImpl(this.getDockerCmdExecFactory().createSaveImageCmdExec(), name);
    }

    @Override
    public CreateImageCmd createImageCmd(String repository, InputStream imageStream) {
        return new CreateImageCmdImpl(this.getDockerCmdExecFactory().createCreateImageCmdExec(), repository, imageStream);
    }

    @Override
    public SearchImagesCmd searchImagesCmd(String term) {
        return new SearchImagesCmdImpl(this.getDockerCmdExecFactory().createSearchImagesCmdExec(), term);
    }

    @Override
    public RemoveImageCmd removeImageCmd(String imageId) {
        return new RemoveImageCmdImpl(this.getDockerCmdExecFactory().createRemoveImageCmdExec(), imageId);
    }

    @Override
    public ListImagesCmd listImagesCmd() {
        return new ListImagesCmdImpl(this.getDockerCmdExecFactory().createListImagesCmdExec());
    }

    @Override
    public InspectImageCmd inspectImageCmd(String imageId) {
        return new InspectImageCmdImpl(this.getDockerCmdExecFactory().createInspectImageCmdExec(), imageId);
    }

    @Override
    public ListContainersCmd listContainersCmd() {
        return new ListContainersCmdImpl(this.getDockerCmdExecFactory().createListContainersCmdExec());
    }

    @Override
    public CreateContainerCmd createContainerCmd(String image) {
        return new CreateContainerCmdImpl(this.getDockerCmdExecFactory().createCreateContainerCmdExec(), image);
    }

    @Override
    public StartContainerCmd startContainerCmd(String containerId) {
        return new StartContainerCmdImpl(this.getDockerCmdExecFactory().createStartContainerCmdExec(), containerId);
    }

    @Override
    public InspectContainerCmd inspectContainerCmd(String containerId) {
        return new InspectContainerCmdImpl(this.getDockerCmdExecFactory().createInspectContainerCmdExec(), containerId);
    }

    @Override
    public ExecCreateCmd execCreateCmd(String containerId) {
        return new ExecCreateCmdImpl(this.getDockerCmdExecFactory().createExecCmdExec(), containerId);
    }

    @Override
    public RemoveContainerCmd removeContainerCmd(String containerId) {
        return new RemoveContainerCmdImpl(this.getDockerCmdExecFactory().createRemoveContainerCmdExec(), containerId);
    }

    @Override
    public WaitContainerCmd waitContainerCmd(String containerId) {
        return new WaitContainerCmdImpl(this.getDockerCmdExecFactory().createWaitContainerCmdExec(), containerId);
    }

    @Override
    public AttachContainerCmd attachContainerCmd(String containerId) {
        return new AttachContainerCmdImpl(this.getDockerCmdExecFactory().createAttachContainerCmdExec(), containerId);
    }

    @Override
    public ExecStartCmd execStartCmd(String execId) {
        return new ExecStartCmdImpl(this.getDockerCmdExecFactory().createExecStartCmdExec(), execId);
    }

    @Override
    public InspectExecCmd inspectExecCmd(String execId) {
        return new InspectExecCmdImpl(this.getDockerCmdExecFactory().createInspectExecCmdExec(), execId);
    }

    @Override
    public LogContainerCmd logContainerCmd(String containerId) {
        return new LogContainerCmdImpl(this.getDockerCmdExecFactory().createLogContainerCmdExec(), containerId);
    }

    @Override
    public CopyFileFromContainerCmd copyFileFromContainerCmd(String containerId, String resource) {
        return new CopyFileFromContainerCmdImpl(this.getDockerCmdExecFactory().createCopyFileFromContainerCmdExec(), containerId, resource);
    }

    @Override
    public CopyArchiveFromContainerCmd copyArchiveFromContainerCmd(String containerId, String resource) {
        return new CopyArchiveFromContainerCmdImpl(this.getDockerCmdExecFactory().createCopyArchiveFromContainerCmdExec(), containerId, resource);
    }

    @Override
    public CopyArchiveToContainerCmd copyArchiveToContainerCmd(String containerId) {
        return new CopyArchiveToContainerCmdImpl(this.getDockerCmdExecFactory().createCopyArchiveToContainerCmdExec(), containerId);
    }

    @Override
    public ContainerDiffCmd containerDiffCmd(String containerId) {
        return new ContainerDiffCmdImpl(this.getDockerCmdExecFactory().createContainerDiffCmdExec(), containerId);
    }

    @Override
    public StopContainerCmd stopContainerCmd(String containerId) {
        return new StopContainerCmdImpl(this.getDockerCmdExecFactory().createStopContainerCmdExec(), containerId);
    }

    @Override
    public KillContainerCmd killContainerCmd(String containerId) {
        return new KillContainerCmdImpl(this.getDockerCmdExecFactory().createKillContainerCmdExec(), containerId);
    }

    @Override
    public UpdateContainerCmd updateContainerCmd(@Nonnull String containerId) {
        return new UpdateContainerCmdImpl(this.getDockerCmdExecFactory().createUpdateContainerCmdExec(), containerId);
    }

    @Override
    public RenameContainerCmd renameContainerCmd(@Nonnull String containerId) {
        return new RenameContainerCmdImpl(this.getDockerCmdExecFactory().createRenameContainerCmdExec(), containerId);
    }

    @Override
    public RestartContainerCmd restartContainerCmd(String containerId) {
        return new RestartContainerCmdImpl(this.getDockerCmdExecFactory().createRestartContainerCmdExec(), containerId);
    }

    @Override
    public CommitCmd commitCmd(String containerId) {
        return new CommitCmdImpl(this.getDockerCmdExecFactory().createCommitCmdExec(), containerId);
    }

    @Override
    public BuildImageCmd buildImageCmd() {
        return new BuildImageCmdImpl(this.getDockerCmdExecFactory().createBuildImageCmdExec());
    }

    @Override
    public BuildImageCmd buildImageCmd(File dockerFileOrFolder) {
        return new BuildImageCmdImpl(this.getDockerCmdExecFactory().createBuildImageCmdExec(), dockerFileOrFolder);
    }

    @Override
    public BuildImageCmd buildImageCmd(InputStream tarInputStream) {
        return new BuildImageCmdImpl(this.getDockerCmdExecFactory().createBuildImageCmdExec(), tarInputStream);
    }

    @Override
    public TopContainerCmd topContainerCmd(String containerId) {
        return new TopContainerCmdImpl(this.getDockerCmdExecFactory().createTopContainerCmdExec(), containerId);
    }

    @Override
    public TagImageCmd tagImageCmd(String imageId, String repository, String tag) {
        return new TagImageCmdImpl(this.getDockerCmdExecFactory().createTagImageCmdExec(), imageId, repository, tag);
    }

    @Override
    public PauseContainerCmd pauseContainerCmd(String containerId) {
        return new PauseContainerCmdImpl(this.getDockerCmdExecFactory().createPauseContainerCmdExec(), containerId);
    }

    @Override
    public UnpauseContainerCmd unpauseContainerCmd(String containerId) {
        return new UnpauseContainerCmdImpl(this.getDockerCmdExecFactory().createUnpauseContainerCmdExec(), containerId);
    }

    @Override
    public EventsCmd eventsCmd() {
        return new EventsCmdImpl(this.getDockerCmdExecFactory().createEventsCmdExec());
    }

    @Override
    public StatsCmd statsCmd(String containerId) {
        return new StatsCmdImpl(this.getDockerCmdExecFactory().createStatsCmdExec(), containerId);
    }

    @Override
    public CreateVolumeCmd createVolumeCmd() {
        return new CreateVolumeCmdImpl(this.getDockerCmdExecFactory().createCreateVolumeCmdExec());
    }

    @Override
    public InspectVolumeCmd inspectVolumeCmd(String name) {
        return new InspectVolumeCmdImpl(this.getDockerCmdExecFactory().createInspectVolumeCmdExec(), name);
    }

    @Override
    public RemoveVolumeCmd removeVolumeCmd(String name) {
        return new RemoveVolumeCmdImpl(this.getDockerCmdExecFactory().createRemoveVolumeCmdExec(), name);
    }

    @Override
    public ListVolumesCmd listVolumesCmd() {
        return new ListVolumesCmdImpl(this.getDockerCmdExecFactory().createListVolumesCmdExec());
    }

    @Override
    public ListNetworksCmd listNetworksCmd() {
        return new ListNetworksCmdImpl(this.getDockerCmdExecFactory().createListNetworksCmdExec());
    }

    @Override
    public InspectNetworkCmd inspectNetworkCmd() {
        return new InpectNetworkCmdImpl(this.getDockerCmdExecFactory().createInspectNetworkCmdExec());
    }

    @Override
    public CreateNetworkCmd createNetworkCmd() {
        return new CreateNetworkCmdImpl(this.getDockerCmdExecFactory().createCreateNetworkCmdExec());
    }

    @Override
    public RemoveNetworkCmd removeNetworkCmd(String networkId) {
        return new RemoveNetworkCmdImpl(this.getDockerCmdExecFactory().createRemoveNetworkCmdExec(), networkId);
    }

    @Override
    public ConnectToNetworkCmd connectToNetworkCmd() {
        return new ConnectToNetworkCmdImpl(this.getDockerCmdExecFactory().createConnectToNetworkCmdExec());
    }

    @Override
    public DisconnectFromNetworkCmd disconnectFromNetworkCmd() {
        return new DisconnectFromNetworkCmdImpl(this.getDockerCmdExecFactory().createDisconnectFromNetworkCmdExec());
    }

    @Override
    public void close() throws IOException {
        this.getDockerCmdExecFactory().close();
    }
}

