/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.core.command;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import org.testifyproject.github.dockerjava.api.model.Frame;
import org.testifyproject.github.dockerjava.api.model.StreamType;

public class FrameReader
implements AutoCloseable {
    private static final int HEADER_SIZE = 8;
    private final byte[] rawBuffer = new byte[1000];
    private final InputStream inputStream;
    private Boolean rawStreamDetected = false;

    public FrameReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    private static StreamType streamType(byte streamType) {
        switch (streamType) {
            case 0: {
                return StreamType.STDIN;
            }
            case 1: {
                return StreamType.STDOUT;
            }
            case 2: {
                return StreamType.STDERR;
            }
        }
        return StreamType.RAW;
    }

    @CheckForNull
    public Frame readFrame() throws IOException {
        int count;
        int headerCount;
        if (this.rawStreamDetected.booleanValue()) {
            int read = this.inputStream.read(this.rawBuffer);
            if (read == -1) {
                return null;
            }
            return new Frame(StreamType.RAW, Arrays.copyOf(this.rawBuffer, read));
        }
        byte[] header = new byte[8];
        int actualHeaderSize = 0;
        do {
            if ((headerCount = this.inputStream.read(header, actualHeaderSize, 8 - actualHeaderSize)) != -1) continue;
            return null;
        } while ((actualHeaderSize += headerCount) < 8);
        StreamType streamType = FrameReader.streamType(header[0]);
        if (streamType.equals((Object)StreamType.RAW)) {
            this.rawStreamDetected = true;
            return new Frame(StreamType.RAW, Arrays.copyOf(header, 8));
        }
        int payloadSize = ((header[4] & 0xFF) << 24) + ((header[5] & 0xFF) << 16) + ((header[6] & 0xFF) << 8) + (header[7] & 0xFF);
        byte[] payload = new byte[payloadSize];
        int actualPayloadSize = 0;
        do {
            if ((count = this.inputStream.read(payload, actualPayloadSize, payloadSize - actualPayloadSize)) != -1) continue;
            if (actualPayloadSize == payloadSize) break;
            throw new IOException(String.format("payload must be %d bytes long, but was %d", payloadSize, actualPayloadSize));
        } while ((actualPayloadSize += count) < payloadSize);
        return new Frame(streamType, payload);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

