/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.core.command;

import java.util.List;
import java.util.Map;
import org.testifyproject.github.dockerjava.api.command.ListContainersCmd;
import org.testifyproject.github.dockerjava.api.model.Container;
import org.testifyproject.github.dockerjava.core.command.AbstrDockerCmd;
import org.testifyproject.github.dockerjava.core.util.FiltersBuilder;
import org.testifyproject.google.common.base.Preconditions;

public class ListContainersCmdImpl
extends AbstrDockerCmd<ListContainersCmd, List<Container>>
implements ListContainersCmd {
    private Integer limit = -1;
    private Boolean showSize;
    private Boolean showAll = false;
    private String sinceId;
    private String beforeId;
    private FiltersBuilder filters = new FiltersBuilder();

    public ListContainersCmdImpl(ListContainersCmd.Exec exec) {
        super(exec);
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Boolean hasShowSizeEnabled() {
        return this.showSize;
    }

    @Override
    public Boolean hasShowAllEnabled() {
        return this.showAll;
    }

    @Override
    public String getSinceId() {
        return this.sinceId;
    }

    @Override
    public String getBeforeId() {
        return this.beforeId;
    }

    @Override
    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }

    @Override
    public ListContainersCmd withShowAll(Boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    @Override
    public ListContainersCmd withShowSize(Boolean showSize) {
        this.showSize = showSize;
        return this;
    }

    @Override
    public ListContainersCmd withLimit(Integer limit) {
        Preconditions.checkNotNull(limit, "limit was not specified");
        Preconditions.checkArgument(limit > 0, "limit must be greater 0");
        this.limit = limit;
        return this;
    }

    @Override
    public ListContainersCmd withSince(String since) {
        Preconditions.checkNotNull(since, "since was not specified");
        this.sinceId = since;
        return this;
    }

    @Override
    public ListContainersCmd withBefore(String before) {
        Preconditions.checkNotNull(before, "before was not specified");
        this.beforeId = before;
        return this;
    }

    @Override
    public ListContainersCmd withLabelFilter(String ... labels) {
        Preconditions.checkNotNull(labels, "labels was not specified");
        this.filters.withLabels(labels);
        return this;
    }

    @Override
    public ListContainersCmd withLabelFilter(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, "labels was not specified");
        this.filters.withLabels(labels);
        return this;
    }

    @Override
    public ListContainersCmd withExitcodeFilter(Integer exitcode) {
        Preconditions.checkNotNull(exitcode, "exitcode was not specified");
        this.filters.withFilter("exitcode", exitcode.toString());
        return this;
    }

    @Override
    public ListContainersCmd withStatusFilter(String status) {
        Preconditions.checkNotNull(status, "status was not specified");
        this.filters.withFilter("status", status);
        return this;
    }
}

