/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.jaxrs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testifyproject.apache.http.config.Registry;
import org.testifyproject.apache.http.config.RegistryBuilder;
import org.testifyproject.apache.http.conn.socket.ConnectionSocketFactory;
import org.testifyproject.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.testifyproject.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.testifyproject.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.testifyproject.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import org.testifyproject.github.dockerjava.api.command.AttachContainerCmd;
import org.testifyproject.github.dockerjava.api.command.AuthCmd;
import org.testifyproject.github.dockerjava.api.command.BuildImageCmd;
import org.testifyproject.github.dockerjava.api.command.CommitCmd;
import org.testifyproject.github.dockerjava.api.command.ConnectToNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.ContainerDiffCmd;
import org.testifyproject.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CopyFileFromContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CreateContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CreateImageCmd;
import org.testifyproject.github.dockerjava.api.command.CreateNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.CreateVolumeCmd;
import org.testifyproject.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.DockerCmdExecFactory;
import org.testifyproject.github.dockerjava.api.command.EventsCmd;
import org.testifyproject.github.dockerjava.api.command.ExecCreateCmd;
import org.testifyproject.github.dockerjava.api.command.ExecStartCmd;
import org.testifyproject.github.dockerjava.api.command.InfoCmd;
import org.testifyproject.github.dockerjava.api.command.InspectContainerCmd;
import org.testifyproject.github.dockerjava.api.command.InspectExecCmd;
import org.testifyproject.github.dockerjava.api.command.InspectImageCmd;
import org.testifyproject.github.dockerjava.api.command.InspectNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.InspectVolumeCmd;
import org.testifyproject.github.dockerjava.api.command.KillContainerCmd;
import org.testifyproject.github.dockerjava.api.command.ListContainersCmd;
import org.testifyproject.github.dockerjava.api.command.ListImagesCmd;
import org.testifyproject.github.dockerjava.api.command.ListNetworksCmd;
import org.testifyproject.github.dockerjava.api.command.ListVolumesCmd;
import org.testifyproject.github.dockerjava.api.command.LogContainerCmd;
import org.testifyproject.github.dockerjava.api.command.PauseContainerCmd;
import org.testifyproject.github.dockerjava.api.command.PingCmd;
import org.testifyproject.github.dockerjava.api.command.PullImageCmd;
import org.testifyproject.github.dockerjava.api.command.PushImageCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveContainerCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveImageCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveVolumeCmd;
import org.testifyproject.github.dockerjava.api.command.RenameContainerCmd;
import org.testifyproject.github.dockerjava.api.command.RestartContainerCmd;
import org.testifyproject.github.dockerjava.api.command.SaveImageCmd;
import org.testifyproject.github.dockerjava.api.command.SearchImagesCmd;
import org.testifyproject.github.dockerjava.api.command.StartContainerCmd;
import org.testifyproject.github.dockerjava.api.command.StatsCmd;
import org.testifyproject.github.dockerjava.api.command.StopContainerCmd;
import org.testifyproject.github.dockerjava.api.command.TagImageCmd;
import org.testifyproject.github.dockerjava.api.command.TopContainerCmd;
import org.testifyproject.github.dockerjava.api.command.UnpauseContainerCmd;
import org.testifyproject.github.dockerjava.api.command.UpdateContainerCmd;
import org.testifyproject.github.dockerjava.api.command.VersionCmd;
import org.testifyproject.github.dockerjava.api.command.WaitContainerCmd;
import org.testifyproject.github.dockerjava.api.exception.DockerClientException;
import org.testifyproject.github.dockerjava.core.DockerClientConfig;
import org.testifyproject.github.dockerjava.core.LocalDirectorySSLConfig;
import org.testifyproject.github.dockerjava.jaxrs.AttachContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.AuthCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.BuildImageCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.CommitCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.ConnectToNetworkCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.ContainerDiffCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.CopyArchiveFromContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.CopyArchiveToContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.CopyFileFromContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.CreateContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.CreateImageCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.CreateNetworkCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.CreateVolumeCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.DisconnectFromNetworkCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.EventsCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.ExecCreateCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.ExecStartCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.InfoCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.InspectContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.InspectExecCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.InspectImageCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.InspectNetworkCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.InspectVolumeCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.KillContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.ListContainersCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.ListImagesCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.ListNetworksCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.ListVolumesCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.LogContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.PauseContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.PingCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.PullImageCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.PushImageCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.RemoveContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.RemoveImageCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.RemoveNetworkCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.RemoveVolumeCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.RenameContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.RestartContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.SaveImageCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.SearchImagesCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.StartContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.StatsCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.StopContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.TagImageCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.TopContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.UnixConnectionSocketFactory;
import org.testifyproject.github.dockerjava.jaxrs.UnpauseContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.UpdateContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.VersionCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.WaitContainerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.connector.ApacheConnectorProvider;
import org.testifyproject.github.dockerjava.jaxrs.filter.JsonClientFilter;
import org.testifyproject.github.dockerjava.jaxrs.filter.ResponseStatusExceptionFilter;
import org.testifyproject.github.dockerjava.jaxrs.filter.SelectiveLoggingFilter;
import org.testifyproject.glassfish.jersey.client.ClientConfig;
import org.testifyproject.google.common.base.Preconditions;

public class DockerCmdExecFactoryImpl
implements DockerCmdExecFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DockerCmdExecFactoryImpl.class.getName());
    private Client client;
    private WebTarget baseResource;
    private Integer readTimeout = null;
    private Integer connectTimeout = null;
    private Integer maxTotalConnections = null;
    private Integer maxPerRouteConnections = null;
    private ClientRequestFilter[] clientRequestFilters = null;
    private ClientResponseFilter[] clientResponseFilters = null;
    private DockerClientConfig dockerClientConfig;
    SSLContext sslContext = null;

    /*
     * Unable to fully structure code
     */
    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(dockerClientConfig, "config was not specified");
        this.dockerClientConfig = dockerClientConfig;
        clientConfig = new ClientConfig();
        clientConfig.connectorProvider(new ApacheConnectorProvider());
        clientConfig.property("org.testifyproject.config.disableAutoDiscovery", true);
        clientConfig.register((Class)ResponseStatusExceptionFilter.class);
        clientConfig.register((Class)JsonClientFilter.class);
        clientConfig.register((Class)JacksonJsonProvider.class);
        clientConfig.register(new SelectiveLoggingFilter(DockerCmdExecFactoryImpl.LOGGER, true));
        if (this.readTimeout != null) {
            clientConfig.property("org.testifyproject.config.client.readTimeout", this.readTimeout);
        }
        if (this.connectTimeout != null) {
            clientConfig.property("org.testifyproject.config.client.connectTimeout", this.connectTimeout);
        }
        if (this.clientResponseFilters != null) {
            for (ClientResponseFilter clientResponseFilter : this.clientResponseFilters) {
                if (clientResponseFilter == null) continue;
                clientConfig.register(clientResponseFilter);
            }
        }
        if (this.clientRequestFilters != null) {
            for (ClientRequestFilter clientRequestFilter : this.clientRequestFilters) {
                if (clientRequestFilter == null) continue;
                clientConfig.register(clientRequestFilter);
            }
        }
        originalUri = dockerClientConfig.getDockerHost();
        protocol = null;
        if (dockerClientConfig.getDockerTlsVerify()) {
            protocol = "https";
            try {
                if (this.sslContext != null) ** GOTO lbl46
                this.sslContext = new LocalDirectorySSLConfig(dockerClientConfig.getDockerCertPath()).getSSLContext();
            }
            catch (Exception ex) {
                throw new DockerClientException("Error in SSL Configuration", ex);
            }
        } else {
            protocol = "http";
        }
lbl46:
        // 3 sources

        if (!originalUri.getScheme().equals("unix")) {
            try {
                originalUri = new URI(originalUri.toString().replaceFirst("tcp", protocol));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.configureProxy(clientConfig, protocol);
        }
        connManager = new PoolingHttpClientConnectionManager(this.getSchemeRegistry(originalUri, this.sslContext));
        if (this.maxTotalConnections != null) {
            connManager.setMaxTotal(this.maxTotalConnections);
        }
        if (this.maxPerRouteConnections != null) {
            connManager.setDefaultMaxPerRoute(this.maxPerRouteConnections);
        }
        clientConfig.property("org.testifyproject.config.apache.client.connectionManager", connManager);
        clientBuilder = ClientBuilder.newBuilder().withConfig(clientConfig);
        if (this.sslContext != null) {
            clientBuilder.sslContext(this.sslContext);
        }
        this.client = clientBuilder.build();
        this.baseResource = this.client.target(this.sanitizeUrl(originalUri).toString()).path(dockerClientConfig.getApiVersion().asWebPathPart());
    }

    private URI sanitizeUrl(URI originalUri) {
        if (originalUri.getScheme().equals("unix")) {
            return UnixConnectionSocketFactory.sanitizeUri(originalUri);
        }
        return originalUri;
    }

    private void configureProxy(ClientConfig clientConfig, String protocol) {
        List<Proxy> proxies = ProxySelector.getDefault().select(this.dockerClientConfig.getDockerHost());
        for (Proxy proxy : proxies) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            if (address == null) continue;
            String hostname = address.getHostName();
            int port = address.getPort();
            clientConfig.property("org.testifyproject.config.client.proxy.uri", "http://" + hostname + ":" + port);
            String httpProxyUser = System.getProperty(protocol + ".proxyUser");
            if (httpProxyUser == null) continue;
            clientConfig.property("org.testifyproject.config.client.proxy.username", httpProxyUser);
            String httpProxyPassword = System.getProperty(protocol + ".proxyPassword");
            if (httpProxyPassword == null) continue;
            clientConfig.property("org.testifyproject.config.client.proxy.password", httpProxyPassword);
        }
    }

    private Registry<ConnectionSocketFactory> getSchemeRegistry(URI originalUri, SSLContext sslContext) {
        RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", PlainConnectionSocketFactory.getSocketFactory());
        if (sslContext != null) {
            registryBuilder.register("https", new SSLConnectionSocketFactory(sslContext));
        }
        registryBuilder.register("unix", new UnixConnectionSocketFactory(originalUri));
        return registryBuilder.build();
    }

    protected WebTarget getBaseResource() {
        Preconditions.checkNotNull(this.baseResource, "Factory not initialized, baseResource not set. You probably forgot to call init()!");
        return this.baseResource;
    }

    protected DockerClientConfig getDockerClientConfig() {
        Preconditions.checkNotNull(this.dockerClientConfig, "Factor not initialized, dockerClientConfig not set. You probably forgot to call init()!");
        return this.dockerClientConfig;
    }

    @Override
    public AuthCmd.Exec createAuthCmdExec() {
        return new AuthCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InfoCmd.Exec createInfoCmdExec() {
        return new InfoCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PingCmd.Exec createPingCmdExec() {
        return new PingCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public VersionCmd.Exec createVersionCmdExec() {
        return new VersionCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PullImageCmd.Exec createPullImageCmdExec() {
        return new PullImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PushImageCmd.Exec createPushImageCmdExec() {
        return new PushImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public SaveImageCmd.Exec createSaveImageCmdExec() {
        return new SaveImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateImageCmd.Exec createCreateImageCmdExec() {
        return new CreateImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public SearchImagesCmd.Exec createSearchImagesCmdExec() {
        return new SearchImagesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveImageCmd.Exec createRemoveImageCmdExec() {
        return new RemoveImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListImagesCmd.Exec createListImagesCmdExec() {
        return new ListImagesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectImageCmd.Exec createInspectImageCmdExec() {
        return new InspectImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListContainersCmd.Exec createListContainersCmdExec() {
        return new ListContainersCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateContainerCmd.Exec createCreateContainerCmdExec() {
        return new CreateContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StartContainerCmd.Exec createStartContainerCmdExec() {
        return new StartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectContainerCmd.Exec createInspectContainerCmdExec() {
        return new InspectContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ExecCreateCmd.Exec createExecCmdExec() {
        return new ExecCreateCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveContainerCmd.Exec createRemoveContainerCmdExec() {
        return new RemoveContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public WaitContainerCmd.Exec createWaitContainerCmdExec() {
        return new WaitContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public AttachContainerCmd.Exec createAttachContainerCmdExec() {
        return new AttachContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ExecStartCmd.Exec createExecStartCmdExec() {
        return new ExecStartCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectExecCmd.Exec createInspectExecCmdExec() {
        return new InspectExecCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public LogContainerCmd.Exec createLogContainerCmdExec() {
        return new LogContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyArchiveFromContainerCmd.Exec createCopyArchiveFromContainerCmdExec() {
        return new CopyArchiveFromContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyFileFromContainerCmd.Exec createCopyFileFromContainerCmdExec() {
        return new CopyFileFromContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyArchiveToContainerCmd.Exec createCopyArchiveToContainerCmdExec() {
        return new CopyArchiveToContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StopContainerCmd.Exec createStopContainerCmdExec() {
        return new StopContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ContainerDiffCmd.Exec createContainerDiffCmdExec() {
        return new ContainerDiffCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public KillContainerCmd.Exec createKillContainerCmdExec() {
        return new KillContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public UpdateContainerCmd.Exec createUpdateContainerCmdExec() {
        return new UpdateContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RenameContainerCmd.Exec createRenameContainerCmdExec() {
        return new RenameContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RestartContainerCmd.Exec createRestartContainerCmdExec() {
        return new RestartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CommitCmd.Exec createCommitCmdExec() {
        return new CommitCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public BuildImageCmd.Exec createBuildImageCmdExec() {
        return new BuildImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public TopContainerCmd.Exec createTopContainerCmdExec() {
        return new TopContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public TagImageCmd.Exec createTagImageCmdExec() {
        return new TagImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PauseContainerCmd.Exec createPauseContainerCmdExec() {
        return new PauseContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public UnpauseContainerCmd.Exec createUnpauseContainerCmdExec() {
        return new UnpauseContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public EventsCmd.Exec createEventsCmdExec() {
        return new EventsCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StatsCmd.Exec createStatsCmdExec() {
        return new StatsCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateVolumeCmd.Exec createCreateVolumeCmdExec() {
        return new CreateVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectVolumeCmd.Exec createInspectVolumeCmdExec() {
        return new InspectVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveVolumeCmd.Exec createRemoveVolumeCmdExec() {
        return new RemoveVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListVolumesCmd.Exec createListVolumesCmdExec() {
        return new ListVolumesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListNetworksCmd.Exec createListNetworksCmdExec() {
        return new ListNetworksCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectNetworkCmd.Exec createInspectNetworkCmdExec() {
        return new InspectNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateNetworkCmd.Exec createCreateNetworkCmdExec() {
        return new CreateNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveNetworkCmd.Exec createRemoveNetworkCmdExec() {
        return new RemoveNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ConnectToNetworkCmd.Exec createConnectToNetworkCmdExec() {
        return new ConnectToNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public DisconnectFromNetworkCmd.Exec createDisconnectFromNetworkCmdExec() {
        return new DisconnectFromNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkNotNull(this.client, "Factory not initialized. You probably forgot to call init()!");
        this.client.close();
    }

    @Override
    public DockerCmdExecFactoryImpl withSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public DockerCmdExecFactoryImpl withReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public DockerCmdExecFactoryImpl withConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public DockerCmdExecFactoryImpl withMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
        return this;
    }

    public DockerCmdExecFactoryImpl withMaxPerRouteConnections(Integer maxPerRouteConnections) {
        this.maxPerRouteConnections = maxPerRouteConnections;
        return this;
    }

    public DockerCmdExecFactoryImpl withClientResponseFilters(ClientResponseFilter ... clientResponseFilter) {
        this.clientResponseFilters = clientResponseFilter;
        return this;
    }

    public DockerCmdExecFactoryImpl withClientRequestFilters(ClientRequestFilter ... clientRequestFilters) {
        this.clientRequestFilters = clientRequestFilters;
        return this;
    }
}

