/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.jaxrs;

import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testifyproject.github.dockerjava.api.async.ResultCallback;
import org.testifyproject.github.dockerjava.api.command.EventsCmd;
import org.testifyproject.github.dockerjava.api.model.Event;
import org.testifyproject.github.dockerjava.core.DockerClientConfig;
import org.testifyproject.github.dockerjava.core.async.JsonStreamProcessor;
import org.testifyproject.github.dockerjava.core.util.FiltersEncoder;
import org.testifyproject.github.dockerjava.jaxrs.AbstrAsyncDockerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.async.AbstractCallbackNotifier;
import org.testifyproject.github.dockerjava.jaxrs.async.GETCallbackNotifier;
import org.testifyproject.google.common.net.UrlEscapers;

public class EventsCmdExec
extends AbstrAsyncDockerCmdExec<EventsCmd, Event>
implements EventsCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsCmdExec.class);

    public EventsCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected AbstractCallbackNotifier<Event> callbackNotifier(EventsCmd command, ResultCallback<Event> resultCallback) {
        WebTarget webTarget = this.getBaseResource().path("/events").queryParam("since", command.getSince()).queryParam("until", command.getUntil());
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters())));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        return new GETCallbackNotifier<Event>(new JsonStreamProcessor<Event>(Event.class), resultCallback, webTarget.request());
    }
}

