/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.netty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Security;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.testifyproject.bouncycastle.jce.provider.BouncyCastleProvider;
import org.testifyproject.github.dockerjava.api.command.AttachContainerCmd;
import org.testifyproject.github.dockerjava.api.command.AuthCmd;
import org.testifyproject.github.dockerjava.api.command.BuildImageCmd;
import org.testifyproject.github.dockerjava.api.command.CommitCmd;
import org.testifyproject.github.dockerjava.api.command.ConnectToNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.ContainerDiffCmd;
import org.testifyproject.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CopyFileFromContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CreateContainerCmd;
import org.testifyproject.github.dockerjava.api.command.CreateImageCmd;
import org.testifyproject.github.dockerjava.api.command.CreateNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.CreateVolumeCmd;
import org.testifyproject.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.DockerCmdExecFactory;
import org.testifyproject.github.dockerjava.api.command.EventsCmd;
import org.testifyproject.github.dockerjava.api.command.ExecCreateCmd;
import org.testifyproject.github.dockerjava.api.command.ExecStartCmd;
import org.testifyproject.github.dockerjava.api.command.InfoCmd;
import org.testifyproject.github.dockerjava.api.command.InspectContainerCmd;
import org.testifyproject.github.dockerjava.api.command.InspectExecCmd;
import org.testifyproject.github.dockerjava.api.command.InspectImageCmd;
import org.testifyproject.github.dockerjava.api.command.InspectNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.InspectVolumeCmd;
import org.testifyproject.github.dockerjava.api.command.KillContainerCmd;
import org.testifyproject.github.dockerjava.api.command.ListContainersCmd;
import org.testifyproject.github.dockerjava.api.command.ListImagesCmd;
import org.testifyproject.github.dockerjava.api.command.ListNetworksCmd;
import org.testifyproject.github.dockerjava.api.command.ListVolumesCmd;
import org.testifyproject.github.dockerjava.api.command.LogContainerCmd;
import org.testifyproject.github.dockerjava.api.command.PauseContainerCmd;
import org.testifyproject.github.dockerjava.api.command.PingCmd;
import org.testifyproject.github.dockerjava.api.command.PullImageCmd;
import org.testifyproject.github.dockerjava.api.command.PushImageCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveContainerCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveImageCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveNetworkCmd;
import org.testifyproject.github.dockerjava.api.command.RemoveVolumeCmd;
import org.testifyproject.github.dockerjava.api.command.RenameContainerCmd;
import org.testifyproject.github.dockerjava.api.command.RestartContainerCmd;
import org.testifyproject.github.dockerjava.api.command.SaveImageCmd;
import org.testifyproject.github.dockerjava.api.command.SearchImagesCmd;
import org.testifyproject.github.dockerjava.api.command.StartContainerCmd;
import org.testifyproject.github.dockerjava.api.command.StatsCmd;
import org.testifyproject.github.dockerjava.api.command.StopContainerCmd;
import org.testifyproject.github.dockerjava.api.command.TagImageCmd;
import org.testifyproject.github.dockerjava.api.command.TopContainerCmd;
import org.testifyproject.github.dockerjava.api.command.UnpauseContainerCmd;
import org.testifyproject.github.dockerjava.api.command.UpdateContainerCmd;
import org.testifyproject.github.dockerjava.api.command.VersionCmd;
import org.testifyproject.github.dockerjava.api.command.WaitContainerCmd;
import org.testifyproject.github.dockerjava.core.DockerClientConfig;
import org.testifyproject.github.dockerjava.core.LocalDirectorySSLConfig;
import org.testifyproject.github.dockerjava.netty.ChannelProvider;
import org.testifyproject.github.dockerjava.netty.WebTarget;
import org.testifyproject.github.dockerjava.netty.exec.AttachContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.AuthCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.BuildImageCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.CommitCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.ConnectToNetworkCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.ContainerDiffCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.CopyArchiveFromContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.CopyArchiveToContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.CopyFileFromContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.CreateContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.CreateImageCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.CreateNetworkCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.CreateVolumeCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.DisconnectFromNetworkCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.EventsCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.ExecCreateCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.ExecStartCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.InfoCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.InspectContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.InspectExecCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.InspectImageCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.InspectNetworkCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.InspectVolumeCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.KillContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.ListContainersCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.ListImagesCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.ListNetworksCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.ListVolumesCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.LogContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.PauseContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.PingCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.PullImageCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.PushImageCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.RemoveContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.RemoveImageCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.RemoveNetworkCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.RemoveVolumeCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.RenameContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.RestartContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.SaveImageCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.SearchImagesCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.StartContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.StatsCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.StopContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.TagImageCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.TopContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.UnpauseContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.UpdateContainerCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.VersionCmdExec;
import org.testifyproject.github.dockerjava.netty.exec.WaitContainerCmdExec;
import org.testifyproject.google.common.base.Preconditions;
import org.testifyproject.netty.bootstrap.Bootstrap;
import org.testifyproject.netty.channel.ChannelInitializer;
import org.testifyproject.netty.channel.EventLoopGroup;
import org.testifyproject.netty.channel.epoll.EpollDomainSocketChannel;
import org.testifyproject.netty.channel.epoll.EpollEventLoopGroup;
import org.testifyproject.netty.channel.nio.NioEventLoopGroup;
import org.testifyproject.netty.channel.socket.DuplexChannel;
import org.testifyproject.netty.channel.socket.SocketChannel;
import org.testifyproject.netty.channel.socket.nio.NioSocketChannel;
import org.testifyproject.netty.channel.unix.DomainSocketAddress;
import org.testifyproject.netty.channel.unix.UnixChannel;
import org.testifyproject.netty.handler.codec.http.HttpClientCodec;
import org.testifyproject.netty.handler.logging.LoggingHandler;
import org.testifyproject.netty.handler.ssl.SslHandler;
import org.testifyproject.netty.util.concurrent.DefaultThreadFactory;

public class DockerCmdExecFactoryImpl
implements DockerCmdExecFactory {
    private static String threadPrefix = "dockerjava-netty";
    private DockerClientConfig dockerClientConfig;
    private Bootstrap bootstrap;
    private EventLoopGroup eventLoopGroup;
    private NettyInitializer nettyInitializer;
    private SSLContext sslContext = null;
    private ChannelProvider channelProvider = new ChannelProvider(){

        @Override
        public DuplexChannel getChannel() {
            DuplexChannel channel = DockerCmdExecFactoryImpl.this.connect();
            channel.pipeline().addLast(new LoggingHandler(this.getClass()));
            return channel;
        }
    };

    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(dockerClientConfig, "config was not specified");
        this.dockerClientConfig = dockerClientConfig;
        this.bootstrap = new Bootstrap();
        String scheme = dockerClientConfig.getDockerHost().getScheme();
        if ("unix".equals(scheme)) {
            this.nettyInitializer = new UnixDomainSocketInitializer();
        } else if ("tcp".equals(scheme)) {
            this.nettyInitializer = new InetSocketInitializer();
        }
        this.eventLoopGroup = this.nettyInitializer.init(this.bootstrap, dockerClientConfig);
    }

    private DuplexChannel connect() {
        try {
            return this.connect(this.bootstrap);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
        return this.nettyInitializer.connect(bootstrap);
    }

    protected DockerClientConfig getDockerClientConfig() {
        Preconditions.checkNotNull(this.dockerClientConfig, "Factor not initialized, dockerClientConfig not set. You probably forgot to call init()!");
        return this.dockerClientConfig;
    }

    public SSLParameters enableHostNameVerification(SSLParameters sslParameters) {
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        return sslParameters;
    }

    @Override
    public CopyArchiveFromContainerCmd.Exec createCopyArchiveFromContainerCmdExec() {
        return new CopyArchiveFromContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyArchiveToContainerCmd.Exec createCopyArchiveToContainerCmdExec() {
        return new CopyArchiveToContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public AuthCmd.Exec createAuthCmdExec() {
        return new AuthCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InfoCmd.Exec createInfoCmdExec() {
        return new InfoCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PingCmd.Exec createPingCmdExec() {
        return new PingCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public VersionCmd.Exec createVersionCmdExec() {
        return new VersionCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PullImageCmd.Exec createPullImageCmdExec() {
        return new PullImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PushImageCmd.Exec createPushImageCmdExec() {
        return new PushImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public SaveImageCmd.Exec createSaveImageCmdExec() {
        return new SaveImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateImageCmd.Exec createCreateImageCmdExec() {
        return new CreateImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public SearchImagesCmd.Exec createSearchImagesCmdExec() {
        return new SearchImagesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveImageCmd.Exec createRemoveImageCmdExec() {
        return new RemoveImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListImagesCmd.Exec createListImagesCmdExec() {
        return new ListImagesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectImageCmd.Exec createInspectImageCmdExec() {
        return new InspectImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListContainersCmd.Exec createListContainersCmdExec() {
        return new ListContainersCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateContainerCmd.Exec createCreateContainerCmdExec() {
        return new CreateContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StartContainerCmd.Exec createStartContainerCmdExec() {
        return new StartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectContainerCmd.Exec createInspectContainerCmdExec() {
        return new InspectContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ExecCreateCmd.Exec createExecCmdExec() {
        return new ExecCreateCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveContainerCmd.Exec createRemoveContainerCmdExec() {
        return new RemoveContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public WaitContainerCmd.Exec createWaitContainerCmdExec() {
        return new WaitContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public AttachContainerCmd.Exec createAttachContainerCmdExec() {
        return new AttachContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ExecStartCmd.Exec createExecStartCmdExec() {
        return new ExecStartCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectExecCmd.Exec createInspectExecCmdExec() {
        return new InspectExecCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public LogContainerCmd.Exec createLogContainerCmdExec() {
        return new LogContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyFileFromContainerCmd.Exec createCopyFileFromContainerCmdExec() {
        return new CopyFileFromContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StopContainerCmd.Exec createStopContainerCmdExec() {
        return new StopContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ContainerDiffCmd.Exec createContainerDiffCmdExec() {
        return new ContainerDiffCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public KillContainerCmd.Exec createKillContainerCmdExec() {
        return new KillContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public UpdateContainerCmd.Exec createUpdateContainerCmdExec() {
        return new UpdateContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RenameContainerCmd.Exec createRenameContainerCmdExec() {
        return new RenameContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RestartContainerCmd.Exec createRestartContainerCmdExec() {
        return new RestartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CommitCmd.Exec createCommitCmdExec() {
        return new CommitCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public BuildImageCmd.Exec createBuildImageCmdExec() {
        return new BuildImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public TopContainerCmd.Exec createTopContainerCmdExec() {
        return new TopContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public TagImageCmd.Exec createTagImageCmdExec() {
        return new TagImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PauseContainerCmd.Exec createPauseContainerCmdExec() {
        return new PauseContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public UnpauseContainerCmd.Exec createUnpauseContainerCmdExec() {
        return new UnpauseContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public EventsCmd.Exec createEventsCmdExec() {
        return new EventsCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StatsCmd.Exec createStatsCmdExec() {
        return new StatsCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateVolumeCmd.Exec createCreateVolumeCmdExec() {
        return new CreateVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectVolumeCmd.Exec createInspectVolumeCmdExec() {
        return new InspectVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveVolumeCmd.Exec createRemoveVolumeCmdExec() {
        return new RemoveVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListVolumesCmd.Exec createListVolumesCmdExec() {
        return new ListVolumesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListNetworksCmd.Exec createListNetworksCmdExec() {
        return new ListNetworksCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectNetworkCmd.Exec createInspectNetworkCmdExec() {
        return new InspectNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateNetworkCmd.Exec createCreateNetworkCmdExec() {
        return new CreateNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveNetworkCmd.Exec createRemoveNetworkCmdExec() {
        return new RemoveNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ConnectToNetworkCmd.Exec createConnectToNetworkCmdExec() {
        return new ConnectToNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public DisconnectFromNetworkCmd.Exec createDisconnectFromNetworkCmdExec() {
        return new DisconnectFromNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkNotNull(this.eventLoopGroup, "Factory not initialized. You probably forgot to call init()!");
        this.eventLoopGroup.shutdownGracefully();
    }

    @Override
    public DockerCmdExecFactory withSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    private WebTarget getBaseResource() {
        return new WebTarget(this.channelProvider);
    }

    private class InetSocketInitializer
    implements NettyInitializer {
        private InetSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(0, new DefaultThreadFactory(threadPrefix));
            InetAddress addr = InetAddress.getLoopbackAddress();
            InetSocketAddress proxyAddress = new InetSocketAddress(addr, 8008);
            Security.addProvider(new BouncyCastleProvider());
            ((Bootstrap)((Bootstrap)bootstrap.group(nioEventLoopGroup)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new HttpClientCodec());
                }
            });
            return nioEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            SslHandler ssl;
            String host = DockerCmdExecFactoryImpl.this.dockerClientConfig.getDockerHost().getHost();
            int port = DockerCmdExecFactoryImpl.this.dockerClientConfig.getDockerHost().getPort();
            if (port == -1) {
                throw new RuntimeException("no port configured for " + host);
            }
            DuplexChannel channel = (DuplexChannel)bootstrap.connect(host, port).sync().channel();
            if (DockerCmdExecFactoryImpl.this.dockerClientConfig.getDockerTlsVerify() && (ssl = this.initSsl(DockerCmdExecFactoryImpl.this.dockerClientConfig)) != null) {
                channel.pipeline().addFirst(ssl);
            }
            return channel;
        }

        private SslHandler initSsl(DockerClientConfig dockerClientConfig) {
            SslHandler ssl = null;
            try {
                String host = dockerClientConfig.getDockerHost().getHost();
                int port = dockerClientConfig.getDockerHost().getPort();
                if (DockerCmdExecFactoryImpl.this.sslContext == null) {
                    DockerCmdExecFactoryImpl.this.sslContext = new LocalDirectorySSLConfig(dockerClientConfig.getDockerCertPath()).getSSLContext();
                }
                SSLEngine engine = DockerCmdExecFactoryImpl.this.sslContext.createSSLEngine(host, port);
                engine.setUseClientMode(true);
                engine.setSSLParameters(DockerCmdExecFactoryImpl.this.enableHostNameVerification(engine.getSSLParameters()));
                ssl = new SslHandler(engine);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ssl;
        }
    }

    private class UnixDomainSocketInitializer
    implements NettyInitializer {
        private UnixDomainSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            EpollEventLoopGroup epollEventLoopGroup = new EpollEventLoopGroup(0, new DefaultThreadFactory(threadPrefix));
            ((Bootstrap)((Bootstrap)bootstrap.group(epollEventLoopGroup)).channel(EpollDomainSocketChannel.class)).handler(new ChannelInitializer<UnixChannel>(){

                @Override
                protected void initChannel(UnixChannel channel) throws Exception {
                    channel.pipeline().addLast(new HttpClientCodec());
                }
            });
            return epollEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            return (DuplexChannel)bootstrap.connect(new DomainSocketAddress("/var/run/docker.sock")).sync().channel();
        }
    }

    private static interface NettyInitializer {
        public EventLoopGroup init(Bootstrap var1, DockerClientConfig var2);

        public DuplexChannel connect(Bootstrap var1) throws InterruptedException;
    }
}

