/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.netty;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.testifyproject.fasterxml.jackson.core.JsonProcessingException;
import org.testifyproject.fasterxml.jackson.core.type.TypeReference;
import org.testifyproject.fasterxml.jackson.databind.ObjectMapper;
import org.testifyproject.github.dockerjava.api.async.ResultCallback;
import org.testifyproject.github.dockerjava.api.exception.DockerClientException;
import org.testifyproject.github.dockerjava.api.model.Frame;
import org.testifyproject.github.dockerjava.core.async.ResultCallbackTemplate;
import org.testifyproject.github.dockerjava.netty.ChannelProvider;
import org.testifyproject.github.dockerjava.netty.MediaType;
import org.testifyproject.github.dockerjava.netty.handler.FramedResponseStreamHandler;
import org.testifyproject.github.dockerjava.netty.handler.HttpConnectionHijackHandler;
import org.testifyproject.github.dockerjava.netty.handler.HttpRequestProvider;
import org.testifyproject.github.dockerjava.netty.handler.HttpResponseHandler;
import org.testifyproject.github.dockerjava.netty.handler.HttpResponseStreamHandler;
import org.testifyproject.github.dockerjava.netty.handler.JsonResponseCallbackHandler;
import org.testifyproject.netty.buffer.Unpooled;
import org.testifyproject.netty.channel.Channel;
import org.testifyproject.netty.channel.ChannelFuture;
import org.testifyproject.netty.channel.ChannelFutureListener;
import org.testifyproject.netty.channel.socket.DuplexChannel;
import org.testifyproject.netty.handler.codec.http.DefaultFullHttpRequest;
import org.testifyproject.netty.handler.codec.http.DefaultHttpRequest;
import org.testifyproject.netty.handler.codec.http.FullHttpRequest;
import org.testifyproject.netty.handler.codec.http.HttpClientCodec;
import org.testifyproject.netty.handler.codec.http.HttpClientUpgradeHandler;
import org.testifyproject.netty.handler.codec.http.HttpHeaderNames;
import org.testifyproject.netty.handler.codec.http.HttpHeaderValues;
import org.testifyproject.netty.handler.codec.http.HttpMethod;
import org.testifyproject.netty.handler.codec.http.HttpRequest;
import org.testifyproject.netty.handler.codec.http.HttpVersion;
import org.testifyproject.netty.handler.codec.http.LastHttpContent;
import org.testifyproject.netty.handler.codec.json.JsonObjectDecoder;
import org.testifyproject.netty.handler.stream.ChunkedStream;
import org.testifyproject.netty.handler.stream.ChunkedWriteHandler;
import org.testifyproject.netty.util.concurrent.Future;
import org.testifyproject.netty.util.concurrent.GenericFutureListener;

public class InvocationBuilder {
    private ChannelProvider channelProvider;
    private String resource;
    private Map<String, String> headers = new HashMap<String, String>();

    public InvocationBuilder(ChannelProvider channelProvider, String resource) {
        this.channelProvider = channelProvider;
        this.resource = resource;
    }

    public InvocationBuilder accept(MediaType mediaType) {
        return this.header(HttpHeaderNames.ACCEPT.toString(), mediaType.getMediaType());
    }

    public InvocationBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public void delete() {
        HttpRequestProvider requestProvider = this.httpDeleteRequestProvider();
        ResponseCallback callback = new ResponseCallback();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, callback);
        DuplexChannel channel = this.getChannel();
        channel.pipeline().addLast(responseHandler);
        this.sendRequest(requestProvider, channel);
        callback.awaitResult();
    }

    public void get(ResultCallback<Frame> resultCallback) {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        FramedResponseStreamHandler streamHandler = new FramedResponseStreamHandler(resultCallback);
        DuplexChannel channel = this.getChannel();
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(streamHandler);
        this.sendRequest(requestProvider, channel);
    }

    public <T> T get(TypeReference<T> typeReference) {
        ResponseCallback callback = new ResponseCallback();
        this.get(typeReference, callback);
        return callback.awaitResult();
    }

    public <T> void get(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        DuplexChannel channel = this.getChannel();
        JsonResponseCallbackHandler<T> jsonResponseHandler = new JsonResponseCallbackHandler<T>(typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(new JsonObjectDecoder());
        channel.pipeline().addLast(jsonResponseHandler);
        this.sendRequest(requestProvider, channel);
    }

    private DuplexChannel getChannel() {
        return this.channelProvider.getChannel();
    }

    private HttpRequestProvider httpDeleteRequestProvider() {
        return new HttpRequestProvider(){

            @Override
            public HttpRequest getHttpRequest(String uri) {
                return InvocationBuilder.this.prepareDeleteRequest(uri);
            }
        };
    }

    private HttpRequestProvider httpGetRequestProvider() {
        return new HttpRequestProvider(){

            @Override
            public HttpRequest getHttpRequest(String uri) {
                return InvocationBuilder.this.prepareGetRequest(uri);
            }
        };
    }

    private HttpRequestProvider httpPostRequestProvider(final Object entity) {
        return new HttpRequestProvider(){

            @Override
            public HttpRequest getHttpRequest(String uri) {
                return InvocationBuilder.this.preparePostRequest(uri, entity);
            }
        };
    }

    private HttpRequestProvider httpPutRequestProvider(final Object entity) {
        return new HttpRequestProvider(){

            @Override
            public HttpRequest getHttpRequest(String uri) {
                return InvocationBuilder.this.preparePutRequest(uri, entity);
            }
        };
    }

    public InputStream post(Object entity) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        DuplexChannel channel = this.getChannel();
        ResponseCallback<InputStream> callback = new ResponseCallback<InputStream>();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, callback);
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler(callback);
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(streamHandler);
        this.sendRequest(requestProvider, channel);
        return callback.awaitResult();
    }

    public void post(Object entity, final InputStream stdin, final ResultCallback<Frame> resultCallback) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        FramedResponseStreamHandler streamHandler = new FramedResponseStreamHandler(resultCallback);
        final DuplexChannel channel = this.getChannel();
        channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                resultCallback.onComplete();
            }
        });
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        HttpConnectionHijackHandler hijackHandler = new HttpConnectionHijackHandler(responseHandler);
        HttpClientCodec httpClientCodec = channel.pipeline().get(HttpClientCodec.class);
        channel.pipeline().addLast(new HttpClientUpgradeHandler(httpClientCodec, hijackHandler, Integer.MAX_VALUE));
        channel.pipeline().addLast(streamHandler);
        this.sendRequest(requestProvider, channel);
        hijackHandler.awaitUpgrade();
        if (stdin != null) {
            new Thread(new Runnable(){

                private int read(InputStream is, byte[] buf) {
                    try {
                        return is.read(buf);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void run() {
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = this.read(stdin, buffer)) != -1) {
                        channel.writeAndFlush(Unpooled.copiedBuffer(buffer, 0, read));
                    }
                    channel.shutdownOutput();
                }
            }).start();
        }
    }

    public <T> T post(Object entity, TypeReference<T> typeReference) {
        ResponseCallback callback = new ResponseCallback();
        this.post(entity, typeReference, callback);
        return callback.awaitResult();
    }

    public <T> void post(Object entity, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        DuplexChannel channel = this.getChannel();
        JsonResponseCallbackHandler<T> jsonResponseHandler = new JsonResponseCallbackHandler<T>(typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(new JsonObjectDecoder());
        channel.pipeline().addLast(jsonResponseHandler);
        this.sendRequest(requestProvider, channel);
    }

    private HttpRequest prepareDeleteRequest(String uri) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.DELETE, uri);
        this.setDefaultHeaders(request);
        return request;
    }

    private FullHttpRequest prepareGetRequest(String uri) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri);
        this.setDefaultHeaders(request);
        return request;
    }

    private HttpRequest preparePostRequest(String uri, Object entity) {
        return this.prepareEntityRequest(uri, entity, HttpMethod.POST);
    }

    private HttpRequest preparePutRequest(String uri, Object entity) {
        return this.prepareEntityRequest(uri, entity, HttpMethod.PUT);
    }

    private HttpRequest prepareEntityRequest(String uri, Object entity, HttpMethod httpMethod) {
        DefaultHttpRequest request = null;
        if (entity != null) {
            byte[] bytes;
            DefaultFullHttpRequest fullRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri);
            try {
                bytes = new ObjectMapper().writeValueAsBytes(entity);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
            fullRequest.content().clear().writeBytes(Unpooled.copiedBuffer(bytes));
            fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
            request = fullRequest;
        } else {
            request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        }
        this.setDefaultHeaders(request);
        return request;
    }

    private void sendRequest(HttpRequestProvider requestProvider, Channel channel) {
        ChannelFuture channelFuture = channel.writeAndFlush(requestProvider.getHttpRequest(this.resource));
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
            }
        });
    }

    private void setDefaultHeaders(HttpRequest request) {
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.headers().set((CharSequence)entry.getKey(), (Object)entry.getValue());
        }
    }

    public <T> T post(TypeReference<T> typeReference, InputStream body) {
        ResponseCallback callback = new ResponseCallback();
        this.post(typeReference, callback, body);
        return callback.awaitResult();
    }

    public <T> void post(TypeReference<T> typeReference, ResultCallback<T> resultCallback, InputStream body) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(null);
        DuplexChannel channel = this.getChannel();
        JsonResponseCallbackHandler<T> jsonResponseHandler = new JsonResponseCallbackHandler<T>(typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChunkedWriteHandler());
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(new JsonObjectDecoder());
        channel.pipeline().addLast(jsonResponseHandler);
        HttpRequest request = requestProvider.getHttpRequest(this.resource);
        if (request instanceof FullHttpRequest) {
            throw new DockerClientException("fatal: request is instance of FullHttpRequest");
        }
        request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        request.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        channel.write(request);
        channel.write(new ChunkedStream(new BufferedInputStream(body, 0x100000), 0x100000));
        channel.write(LastHttpContent.EMPTY_LAST_CONTENT);
        channel.flush();
    }

    public InputStream get() {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        DuplexChannel channel = this.getChannel();
        ResponseCallback<InputStream> resultCallback = new ResponseCallback<InputStream>();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler(resultCallback);
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(streamHandler);
        this.sendRequest(requestProvider, channel);
        return resultCallback.awaitResult();
    }

    public void put(InputStream body, MediaType mediaType) {
        HttpRequestProvider requestProvider = this.httpPutRequestProvider(null);
        DuplexChannel channel = this.getChannel();
        ResponseCallback resultCallback = new ResponseCallback();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChunkedWriteHandler());
        channel.pipeline().addLast(responseHandler);
        HttpRequest request = requestProvider.getHttpRequest(this.resource);
        if (request instanceof FullHttpRequest) {
            throw new DockerClientException("fatal: request is instance of FullHttpRequest");
        }
        request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        request.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType.getMediaType());
        channel.write(request);
        channel.write(new ChunkedStream(new BufferedInputStream(body, 0x100000)));
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
        resultCallback.awaitResult();
    }

    public class ResponseCallback<T>
    extends ResultCallbackTemplate<ResponseCallback<T>, T> {
        private T result = null;

        public T awaitResult() {
            try {
                this.awaitCompletion();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.result;
        }

        @Override
        public void onNext(T object) {
            this.result = object;
        }
    }
}

