/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.netty.exec;

import java.io.IOException;
import org.testifyproject.apache.commons.codec.binary.Base64;
import org.testifyproject.fasterxml.jackson.databind.ObjectMapper;
import org.testifyproject.fasterxml.jackson.databind.node.ObjectNode;
import org.testifyproject.github.dockerjava.api.model.AuthConfig;
import org.testifyproject.github.dockerjava.api.model.AuthConfigurations;
import org.testifyproject.github.dockerjava.core.DockerClientConfig;
import org.testifyproject.github.dockerjava.core.RemoteApiVersion;
import org.testifyproject.github.dockerjava.netty.WebTarget;
import org.testifyproject.google.common.base.Preconditions;

public abstract class AbstrDockerCmdExec {
    private final DockerClientConfig dockerClientConfig;
    private final WebTarget baseResource;

    public AbstrDockerCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(baseResource, "baseResource was not specified");
        Preconditions.checkNotNull(dockerClientConfig, "dockerClientConfig was not specified");
        this.baseResource = baseResource;
        this.dockerClientConfig = dockerClientConfig;
    }

    protected WebTarget getBaseResource() {
        return this.baseResource;
    }

    protected AuthConfigurations getBuildAuthConfigs() {
        return this.dockerClientConfig.getAuthConfigurations();
    }

    protected String registryAuth(AuthConfig authConfig) {
        try {
            return Base64.encodeBase64String(new ObjectMapper().writeValueAsString(authConfig).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String registryConfigs(AuthConfigurations authConfigs) {
        try {
            String json;
            ObjectMapper objectMapper = new ObjectMapper();
            RemoteApiVersion apiVersion = this.dockerClientConfig.getApiVersion();
            if (apiVersion.equals(RemoteApiVersion.UNKNOWN_VERSION)) {
                ObjectNode rootNode = (ObjectNode)objectMapper.valueToTree(authConfigs.getConfigs());
                ObjectNode authNodes = (ObjectNode)objectMapper.valueToTree(authConfigs);
                rootNode.setAll(authNodes);
                json = rootNode.toString();
            } else {
                json = apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_19) ? objectMapper.writeValueAsString(authConfigs.getConfigs()) : objectMapper.writeValueAsString(authConfigs);
            }
            return Base64.encodeBase64String(json.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean bool(Boolean bool) {
        return bool != null && bool != false;
    }

    protected WebTarget booleanQueryParam(WebTarget webTarget, String name, Boolean value) {
        if (this.bool(value)) {
            webTarget = webTarget.queryParam(name, this.bool(value) + "");
        }
        return webTarget;
    }
}

