/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.glassfish.jersey.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.ext.ExceptionMapper;
import org.testifyproject.glassfish.hk2.api.ServiceHandle;
import org.testifyproject.glassfish.hk2.api.ServiceLocator;
import org.testifyproject.glassfish.hk2.utilities.binding.AbstractBinder;
import org.testifyproject.glassfish.jersey.internal.LocalizationMessages;
import org.testifyproject.glassfish.jersey.internal.inject.Providers;
import org.testifyproject.glassfish.jersey.internal.util.ReflectionHelper;
import org.testifyproject.glassfish.jersey.internal.util.collection.ClassTypePair;
import org.testifyproject.glassfish.jersey.spi.ExceptionMappers;
import org.testifyproject.glassfish.jersey.spi.ExtendedExceptionMapper;

public class ExceptionMapperFactory
implements ExceptionMappers {
    private static final Logger LOGGER = Logger.getLogger(ExceptionMapperFactory.class.getName());
    private Set<ExceptionMapperType> exceptionMapperTypes = new LinkedHashSet<ExceptionMapperType>();

    @Override
    public <T extends Throwable> ExceptionMapper<T> findMapping(T exceptionInstance) {
        return this.find(exceptionInstance.getClass(), exceptionInstance);
    }

    @Override
    public <T extends Throwable> ExceptionMapper<T> find(Class<T> type) {
        return this.find(type, null);
    }

    private <T extends Throwable> ExceptionMapper<T> find(Class<T> type, T exceptionInstance) {
        TreeMap<Integer, ExceptionMapper> orderedMappers = new TreeMap<Integer, ExceptionMapper>();
        for (ExceptionMapperType mapperType : this.exceptionMapperTypes) {
            int d = this.distance(type, mapperType.exceptionType);
            if (d < 0) continue;
            orderedMappers.put(d, mapperType.mapper.getService());
        }
        if (orderedMappers.size() == 0) {
            return null;
        }
        if (exceptionInstance != null) {
            for (ExceptionMapper mapper : orderedMappers.values()) {
                if (mapper instanceof ExtendedExceptionMapper) {
                    boolean mappable = ((ExtendedExceptionMapper)mapper).isMappable(exceptionInstance);
                    if (!mappable) continue;
                    return mapper;
                }
                return mapper;
            }
            return null;
        }
        return (ExceptionMapper)orderedMappers.values().iterator().next();
    }

    @Inject
    public ExceptionMapperFactory(ServiceLocator locator) {
        Collection<ServiceHandle<ExceptionMapper>> mapperHandles = Providers.getAllServiceHandles(locator, ExceptionMapper.class);
        for (ServiceHandle<ExceptionMapper> mapperHandle : mapperHandles) {
            ExceptionMapper mapper = mapperHandle.getService();
            if (Proxy.isProxyClass(mapper.getClass())) {
                Class<? extends Throwable> c;
                TreeSet<Class<? extends ExceptionMapper>> mapperTypes = new TreeSet<Class<? extends ExceptionMapper>>(new Comparator<Class<? extends ExceptionMapper>>(){

                    @Override
                    public int compare(Class<? extends ExceptionMapper> o1, Class<? extends ExceptionMapper> o2) {
                        return o1.isAssignableFrom(o2) ? -1 : 1;
                    }
                });
                Set<Type> contracts = mapperHandle.getActiveDescriptor().getContractTypes();
                for (Type contract : contracts) {
                    if (!(contract instanceof Class) || !ExceptionMapper.class.isAssignableFrom((Class)contract) || contract == ExceptionMapper.class) continue;
                    mapperTypes.add((Class)contract);
                }
                if (mapperTypes.isEmpty() || (c = this.getExceptionType((Class)mapperTypes.first())) == null) continue;
                this.exceptionMapperTypes.add(new ExceptionMapperType(mapperHandle, c));
                continue;
            }
            Class<? extends Throwable> c = this.getExceptionType(mapper.getClass());
            if (c == null) continue;
            this.exceptionMapperTypes.add(new ExceptionMapperType(mapperHandle, c));
        }
    }

    private int distance(Class<?> c, Class<?> emtc) {
        int distance = 0;
        if (!emtc.isAssignableFrom(c)) {
            return -1;
        }
        while (c != emtc) {
            c = c.getSuperclass();
            ++distance;
        }
        return distance;
    }

    private Class<? extends Throwable> getExceptionType(Class<? extends ExceptionMapper> c) {
        Class t = this.getType(c);
        if (Throwable.class.isAssignableFrom(t)) {
            return t;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning(LocalizationMessages.EXCEPTION_MAPPER_SUPPORTED_TYPE_UNKNOWN(c.getName()));
        }
        return null;
    }

    private Class getType(Class<? extends ExceptionMapper> clazz) {
        for (Class<? extends ExceptionMapper> clazzHolder = clazz; clazzHolder != Object.class; clazzHolder = clazzHolder.getSuperclass()) {
            Class type = this.getTypeFromInterface(clazzHolder, clazz);
            if (type == null) continue;
            return type;
        }
        throw new ProcessingException(LocalizationMessages.ERROR_FINDING_EXCEPTION_MAPPER_TYPE(clazz));
    }

    private Class getTypeFromInterface(Class<?> clazz, Class<? extends ExceptionMapper> original) {
        Type[] types;
        for (Type type : types = clazz.getGenericInterfaces()) {
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                if (pt.getRawType() != ExceptionMapper.class && pt.getRawType() != ExtendedExceptionMapper.class) continue;
                return this.getResolvedType(pt.getActualTypeArguments()[0], original, clazz);
            }
            if (!(type instanceof Class) || !ExceptionMapper.class.isAssignableFrom(clazz = (Class)type)) continue;
            return this.getTypeFromInterface(clazz, original);
        }
        return null;
    }

    private Class getResolvedType(Type t, Class c, Class dc) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof TypeVariable) {
            ClassTypePair ct = ReflectionHelper.resolveTypeVariable(c, dc, (TypeVariable)t);
            if (ct != null) {
                return ct.rawClass();
            }
            return null;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return (Class)pt.getRawType();
        }
        return null;
    }

    private static class ExceptionMapperType {
        ServiceHandle<ExceptionMapper> mapper;
        Class<? extends Throwable> exceptionType;

        public ExceptionMapperType(ServiceHandle<ExceptionMapper> mapper, Class<? extends Throwable> exceptionType) {
            this.mapper = mapper;
            this.exceptionType = exceptionType;
        }
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bindAsContract(ExceptionMapperFactory.class).to(ExceptionMappers.class).in(Singleton.class);
        }
    }
}

