/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.glassfish.jersey.process.internal;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testifyproject.glassfish.hk2.api.ServiceLocator;
import org.testifyproject.glassfish.jersey.internal.LocalizationMessages;
import org.testifyproject.glassfish.jersey.internal.inject.Providers;
import org.testifyproject.glassfish.jersey.internal.util.collection.LazyValue;
import org.testifyproject.glassfish.jersey.internal.util.collection.Value;
import org.testifyproject.glassfish.jersey.internal.util.collection.Values;
import org.testifyproject.glassfish.jersey.spi.RequestExecutorProvider;

public abstract class RequestExecutorFactory {
    private static final Logger LOGGER = Logger.getLogger(RequestExecutorFactory.class.getName());
    private final RequestExecutorProvider executorProvider;
    private final LazyValue<ExecutorService> executorValue;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public RequestExecutorFactory(ServiceLocator locator, Object ... args) {
        Iterator<RequestExecutorProvider> providersIterator = Providers.getAllProviders(locator, RequestExecutorProvider.class).iterator();
        if (providersIterator.hasNext()) {
            this.executorProvider = providersIterator.next();
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(LocalizationMessages.USING_CUSTOM_REQUEST_EXECUTOR_PROVIDER(this.executorProvider.getClass().getName()));
                if (providersIterator.hasNext()) {
                    StringBuilder msg = new StringBuilder(providersIterator.next().getClass().getName());
                    while (providersIterator.hasNext()) {
                        msg.append(", ").append(providersIterator.next().getClass().getName());
                    }
                    LOGGER.config(LocalizationMessages.IGNORED_CUSTOM_REQUEST_EXECUTOR_PROVIDERS(msg.toString()));
                }
            }
        } else {
            this.executorProvider = this.getDefaultProvider(args);
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(LocalizationMessages.USING_DEFAULT_REQUEST_EXECUTOR_PROVIDER(this.executorProvider.getClass().getName()));
            }
        }
        this.executorValue = Values.lazy(new Value<ExecutorService>(){

            @Override
            public ExecutorService get() {
                return RequestExecutorFactory.this.executorProvider.getRequestingExecutor();
            }
        });
    }

    protected abstract RequestExecutorProvider getDefaultProvider(Object ... var1);

    public final ExecutorService getExecutor() {
        if (this.closed.get()) {
            throw new IllegalStateException(LocalizationMessages.REQUEST_EXECUTOR_FACTORY_CLOSED(this.getClass().getName()));
        }
        return (ExecutorService)this.executorValue.get();
    }

    public final void close() {
        if (this.closed.compareAndSet(false, true) && this.executorValue.isInitialized()) {
            this.executorProvider.releaseRequestingExecutor((ExecutorService)this.executorValue.get());
        }
    }
}

