/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.jvnet.hk2.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.testifyproject.aopalliance.intercept.MethodInterceptor;
import org.testifyproject.aopalliance.intercept.MethodInvocation;
import org.testifyproject.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.testifyproject.jvnet.hk2.internal.ServiceLocatorImpl;
import org.testifyproject.util.proxy.MethodHandler;

public class MethodInterceptorHandler
implements MethodHandler {
    private final ServiceLocatorImpl locator;
    private final Map<Method, List<MethodInterceptor>> interceptorLists;

    MethodInterceptorHandler(ServiceLocatorImpl locator, Map<Method, List<MethodInterceptor>> interceptorLists) {
        this.locator = locator;
        this.interceptorLists = interceptorLists;
    }

    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        List<MethodInterceptor> interceptors = this.interceptorLists.get(thisMethod);
        if (interceptors == null || interceptors.isEmpty()) {
            return ReflectionHelper.invoke(self, proceed, args, this.locator.getNeutralContextClassLoader());
        }
        if (!(interceptors instanceof RandomAccess)) {
            interceptors = new ArrayList<MethodInterceptor>(interceptors);
        }
        MethodInterceptor nextInterceptor = interceptors.get(0);
        return nextInterceptor.invoke(new MethodInvocationImpl(args, thisMethod, self, interceptors, 0, proceed));
    }

    private class MethodInvocationImpl
    implements MethodInvocation {
        private final Object[] arguments;
        private final Method method;
        private final Object myself;
        private final List<MethodInterceptor> interceptors;
        private final int index;
        private final Method proceed;

        private MethodInvocationImpl(Object[] arguments, Method method, Object myself, List<MethodInterceptor> interceptors, int index, Method proceed) {
            this.arguments = arguments;
            this.method = method;
            this.myself = myself;
            this.interceptors = interceptors;
            this.index = index;
            this.proceed = proceed;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public AccessibleObject getStaticPart() {
            return this.method;
        }

        @Override
        public Object getThis() {
            return this.myself;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Object proceed() throws Throwable {
            int newIndex = this.index + 1;
            if (newIndex >= this.interceptors.size()) {
                return ReflectionHelper.invoke(this.myself, this.proceed, this.arguments, MethodInterceptorHandler.this.locator.getNeutralContextClassLoader());
            }
            MethodInterceptor nextInterceptor = this.interceptors.get(newIndex);
            return nextInterceptor.invoke(new MethodInvocationImpl(this.arguments, this.method, this.myself, this.interceptors, newIndex, this.proceed));
        }
    }
}

