/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.channel;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.testifyproject.netty.channel.Channel;
import org.testifyproject.netty.channel.ChannelFuture;
import org.testifyproject.netty.channel.ChannelHandlerInvoker;
import org.testifyproject.netty.channel.ChannelPromise;
import org.testifyproject.netty.channel.DefaultChannelHandlerInvoker;
import org.testifyproject.netty.channel.DefaultChannelPromise;
import org.testifyproject.netty.channel.EventLoop;
import org.testifyproject.netty.channel.EventLoopGroup;
import org.testifyproject.netty.util.concurrent.EventExecutorGroup;
import org.testifyproject.netty.util.concurrent.SingleThreadEventExecutor;

public abstract class SingleThreadEventLoop
extends SingleThreadEventExecutor
implements EventLoop {
    private final ChannelHandlerInvoker invoker = new DefaultChannelHandlerInvoker(this);

    protected SingleThreadEventLoop(EventLoopGroup parent, ThreadFactory threadFactory, boolean addTaskWakesUp) {
        super((EventExecutorGroup)parent, threadFactory, addTaskWakesUp);
    }

    protected SingleThreadEventLoop(EventLoopGroup parent, Executor executor, boolean addTaskWakesUp) {
        super((EventExecutorGroup)parent, executor, addTaskWakesUp);
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelHandlerInvoker asInvoker() {
        return this.invoker;
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(channel, new DefaultChannelPromise(channel, this));
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        channel.unsafe().register(this, promise);
        return promise;
    }

    @Override
    protected boolean wakesUpForTask(Runnable task) {
        return !(task instanceof NonWakeupRunnable);
    }

    static interface NonWakeupRunnable
    extends Runnable {
    }
}

