/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.channel.unix;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.testifyproject.netty.channel.ChannelException;
import org.testifyproject.netty.channel.unix.DatagramSocketAddress;
import org.testifyproject.netty.channel.unix.DomainSocketAddress;
import org.testifyproject.netty.channel.unix.Errors;
import org.testifyproject.netty.channel.unix.FileDescriptor;
import org.testifyproject.netty.channel.unix.NativeInetAddress;
import org.testifyproject.netty.util.CharsetUtil;

public final class Socket
extends FileDescriptor {
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;

    public Socket(int fd) {
        super(fd);
    }

    public void shutdown() throws IOException {
        this.shutdown(!this.inputShutdown, !this.outputShutdown);
    }

    public void shutdown(boolean read, boolean write) throws IOException {
        this.inputShutdown = read || this.inputShutdown;
        this.outputShutdown = write || this.outputShutdown;
        this.shutdown0(read, write);
    }

    private void shutdown0(boolean read, boolean write) throws IOException {
        int res = Socket.shutdown(this.intValue(), read, write);
        if (res < 0) {
            Errors.ioResult("shutdown", res, Errors.CONNECTION_NOT_CONNECTED_SHUTDOWN_EXCEPTION);
        }
    }

    public boolean isShutdown() {
        return this.isInputShutdown() && this.isOutputShutdown();
    }

    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    public int sendTo(ByteBuffer buf, int pos, int limit, InetAddress addr, int port) throws IOException {
        int scopeId;
        byte[] address;
        if (addr instanceof Inet6Address) {
            address = addr.getAddress();
            scopeId = ((Inet6Address)addr).getScopeId();
        } else {
            scopeId = 0;
            address = NativeInetAddress.ipv4MappedIpv6Address(addr.getAddress());
        }
        int res = Socket.sendTo(this.intValue(), buf, pos, limit, address, scopeId, port);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("sendTo", res, Errors.CONNECTION_RESET_EXCEPTION_SENDTO);
    }

    public int sendToAddress(long memoryAddress, int pos, int limit, InetAddress addr, int port) throws IOException {
        int scopeId;
        byte[] address;
        if (addr instanceof Inet6Address) {
            address = addr.getAddress();
            scopeId = ((Inet6Address)addr).getScopeId();
        } else {
            scopeId = 0;
            address = NativeInetAddress.ipv4MappedIpv6Address(addr.getAddress());
        }
        int res = Socket.sendToAddress(this.intValue(), memoryAddress, pos, limit, address, scopeId, port);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("sendToAddress", res, Errors.CONNECTION_RESET_EXCEPTION_SENDTO);
    }

    public int sendToAddresses(long memoryAddress, int length, InetAddress addr, int port) throws IOException {
        int scopeId;
        byte[] address;
        if (addr instanceof Inet6Address) {
            address = addr.getAddress();
            scopeId = ((Inet6Address)addr).getScopeId();
        } else {
            scopeId = 0;
            address = NativeInetAddress.ipv4MappedIpv6Address(addr.getAddress());
        }
        int res = Socket.sendToAddresses(this.intValue(), memoryAddress, length, address, scopeId, port);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("sendToAddresses", res, Errors.CONNECTION_RESET_EXCEPTION_SENDMSG);
    }

    public DatagramSocketAddress recvFrom(ByteBuffer buf, int pos, int limit) throws IOException {
        return Socket.recvFrom(this.intValue(), buf, pos, limit);
    }

    public DatagramSocketAddress recvFromAddress(long memoryAddress, int pos, int limit) throws IOException {
        return Socket.recvFromAddress(this.intValue(), memoryAddress, pos, limit);
    }

    public boolean connect(SocketAddress socketAddress) throws IOException {
        int res;
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            NativeInetAddress address = NativeInetAddress.newInstance(inetSocketAddress.getAddress());
            res = Socket.connect(this.intValue(), address.address, address.scopeId, inetSocketAddress.getPort());
        } else if (socketAddress instanceof DomainSocketAddress) {
            DomainSocketAddress unixDomainSocketAddress = (DomainSocketAddress)socketAddress;
            res = Socket.connectDomainSocket(this.intValue(), unixDomainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else {
            throw new Error("Unexpected SocketAddress implementation " + socketAddress);
        }
        if (res < 0) {
            if (res == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            throw Errors.newConnectException("connect", res);
        }
        return true;
    }

    public boolean finishConnect() throws IOException {
        int res = Socket.finishConnect(this.intValue());
        if (res < 0) {
            if (res == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            throw Errors.newConnectException("finishConnect", res);
        }
        return true;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)socketAddress;
            NativeInetAddress address = NativeInetAddress.newInstance(addr.getAddress());
            int res = Socket.bind(this.intValue(), address.address, address.scopeId, addr.getPort());
            if (res < 0) {
                throw Errors.newIOException("bind", res);
            }
        } else if (socketAddress instanceof DomainSocketAddress) {
            DomainSocketAddress addr = (DomainSocketAddress)socketAddress;
            int res = Socket.bindDomainSocket(this.intValue(), addr.path().getBytes(CharsetUtil.UTF_8));
            if (res < 0) {
                throw Errors.newIOException("bind", res);
            }
        } else {
            throw new Error("Unexpected SocketAddress implementation " + socketAddress);
        }
    }

    public void listen(int backlog) throws IOException {
        int res = Socket.listen(this.intValue(), backlog);
        if (res < 0) {
            throw Errors.newIOException("listen", res);
        }
    }

    public int accept(byte[] addr) throws IOException {
        int res = Socket.accept(this.intValue(), addr);
        if (res >= 0) {
            return res;
        }
        if (res == Errors.ERRNO_EAGAIN_NEGATIVE || res == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("accept", res);
    }

    public InetSocketAddress remoteAddress() {
        byte[] addr = Socket.remoteAddress(this.intValue());
        if (addr == null) {
            return null;
        }
        return NativeInetAddress.address(addr, 0, addr.length);
    }

    public InetSocketAddress localAddress() {
        byte[] addr = Socket.localAddress(this.intValue());
        if (addr == null) {
            return null;
        }
        return NativeInetAddress.address(addr, 0, addr.length);
    }

    public int getReceiveBufferSize() {
        return Socket.getReceiveBufferSize(this.intValue());
    }

    public int getSendBufferSize() {
        return Socket.getSendBufferSize(this.intValue());
    }

    public boolean isKeepAlive() {
        return Socket.isKeepAlive(this.intValue()) != 0;
    }

    public boolean isTcpNoDelay() {
        return Socket.isTcpNoDelay(this.intValue()) != 0;
    }

    public boolean isTcpCork() {
        return Socket.isTcpCork(this.intValue()) != 0;
    }

    public int getSoLinger() {
        return Socket.getSoLinger(this.intValue());
    }

    public int getSoError() {
        return Socket.getSoError(this.intValue());
    }

    public void setKeepAlive(boolean keepAlive) {
        Socket.setKeepAlive(this.intValue(), keepAlive ? 1 : 0);
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        Socket.setReceiveBufferSize(this.intValue(), receiveBufferSize);
    }

    public void setSendBufferSize(int sendBufferSize) {
        Socket.setSendBufferSize(this.intValue(), sendBufferSize);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        Socket.setTcpNoDelay(this.intValue(), tcpNoDelay ? 1 : 0);
    }

    public void setTcpCork(boolean tcpCork) {
        Socket.setTcpCork(this.intValue(), tcpCork ? 1 : 0);
    }

    public void setSoLinger(int soLinger) {
        Socket.setSoLinger(this.intValue(), soLinger);
    }

    @Override
    public String toString() {
        return "Socket{fd=" + this.intValue() + '}';
    }

    public static Socket newSocketStream() {
        int res = Socket.newSocketStreamFd();
        if (res < 0) {
            throw new ChannelException(Errors.newIOException("newSocketStream", res));
        }
        return new Socket(res);
    }

    public static Socket newSocketDgram() {
        int res = Socket.newSocketDgramFd();
        if (res < 0) {
            throw new ChannelException(Errors.newIOException("newSocketDgram", res));
        }
        return new Socket(res);
    }

    public static Socket newSocketDomain() {
        int res = Socket.newSocketDomainFd();
        if (res < 0) {
            throw new ChannelException(Errors.newIOException("newSocketDomain", res));
        }
        return new Socket(res);
    }

    private static native int shutdown(int var0, boolean var1, boolean var2);

    private static native int connect(int var0, byte[] var1, int var2, int var3);

    private static native int connectDomainSocket(int var0, byte[] var1);

    private static native int finishConnect(int var0);

    private static native int bind(int var0, byte[] var1, int var2, int var3);

    private static native int bindDomainSocket(int var0, byte[] var1);

    private static native int listen(int var0, int var1);

    private static native int accept(int var0, byte[] var1);

    private static native byte[] remoteAddress(int var0);

    private static native byte[] localAddress(int var0);

    private static native int sendTo(int var0, ByteBuffer var1, int var2, int var3, byte[] var4, int var5, int var6);

    private static native int sendToAddress(int var0, long var1, int var3, int var4, byte[] var5, int var6, int var7);

    private static native int sendToAddresses(int var0, long var1, int var3, byte[] var4, int var5, int var6);

    private static native DatagramSocketAddress recvFrom(int var0, ByteBuffer var1, int var2, int var3) throws IOException;

    private static native DatagramSocketAddress recvFromAddress(int var0, long var1, int var3, int var4) throws IOException;

    private static native int newSocketStreamFd();

    private static native int newSocketDgramFd();

    private static native int newSocketDomainFd();

    private static native int getReceiveBufferSize(int var0);

    private static native int getSendBufferSize(int var0);

    private static native int isKeepAlive(int var0);

    private static native int isTcpNoDelay(int var0);

    private static native int isTcpCork(int var0);

    private static native int getSoLinger(int var0);

    private static native int getSoError(int var0);

    private static native void setKeepAlive(int var0, int var1);

    private static native void setReceiveBufferSize(int var0, int var1);

    private static native void setSendBufferSize(int var0, int var1);

    private static native void setTcpNoDelay(int var0, int var1);

    private static native void setTcpCork(int var0, int var1);

    private static native void setSoLinger(int var0, int var1);
}

