/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.handler.codec.base64;

import java.util.List;
import org.testifyproject.netty.buffer.ByteBuf;
import org.testifyproject.netty.channel.ChannelHandler;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.handler.codec.MessageToMessageEncoder;
import org.testifyproject.netty.handler.codec.base64.Base64;
import org.testifyproject.netty.handler.codec.base64.Base64Dialect;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.breakLines = breakLines;
        this.dialect = dialect;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

