/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.handler.codec.marshalling;

import org.testifyproject.jboss.marshalling.Marshaller;
import org.testifyproject.jboss.marshalling.MarshallerFactory;
import org.testifyproject.jboss.marshalling.MarshallingConfiguration;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.handler.codec.marshalling.MarshallerProvider;
import org.testifyproject.netty.util.concurrent.FastThreadLocal;

public class ThreadLocalMarshallerProvider
implements MarshallerProvider {
    private final FastThreadLocal<Marshaller> marshallers = new FastThreadLocal();
    private final MarshallerFactory factory;
    private final MarshallingConfiguration config;

    public ThreadLocalMarshallerProvider(MarshallerFactory factory, MarshallingConfiguration config) {
        this.factory = factory;
        this.config = config;
    }

    @Override
    public Marshaller getMarshaller(ChannelHandlerContext ctx) throws Exception {
        Marshaller marshaller = this.marshallers.get();
        if (marshaller == null) {
            marshaller = this.factory.createMarshaller(this.config);
            this.marshallers.set(marshaller);
        }
        return marshaller;
    }
}

