/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.handler.codec.serialization;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.testifyproject.netty.buffer.ByteBuf;
import org.testifyproject.netty.buffer.ByteBufOutputStream;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.handler.codec.MessageToByteEncoder;
import org.testifyproject.netty.util.Attribute;
import org.testifyproject.netty.util.AttributeKey;

public class CompatibleObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final AttributeKey<ObjectOutputStream> OOS = AttributeKey.valueOf(CompatibleObjectEncoder.class, "OOS");
    private final int resetInterval;
    private int writtenObjects;

    public CompatibleObjectEncoder() {
        this(16);
    }

    public CompatibleObjectEncoder(int resetInterval) {
        if (resetInterval < 0) {
            throw new IllegalArgumentException("resetInterval: " + resetInterval);
        }
        this.resetInterval = resetInterval;
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return new ObjectOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        ObjectOutputStream newOos;
        Attribute<ObjectOutputStream> oosAttr = ctx.attr(OOS);
        ObjectOutputStream oos = oosAttr.get();
        if (oos == null && (newOos = oosAttr.setIfAbsent(oos = this.newObjectOutputStream(new ByteBufOutputStream(out)))) != null) {
            oos = newOos;
        }
        ObjectOutputStream objectOutputStream = oos;
        synchronized (objectOutputStream) {
            if (this.resetInterval != 0) {
                ++this.writtenObjects;
                if (this.writtenObjects % this.resetInterval == 0) {
                    oos.reset();
                }
            }
            oos.writeObject(msg);
            oos.flush();
        }
    }
}

