/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.handler.codec.serialization;

import org.testifyproject.netty.buffer.ByteBuf;
import org.testifyproject.netty.buffer.ByteBufInputStream;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.testifyproject.netty.handler.codec.serialization.ClassResolver;
import org.testifyproject.netty.handler.codec.serialization.CompactObjectInputStream;

public class ObjectDecoder
extends LengthFieldBasedFrameDecoder {
    private final ClassResolver classResolver;

    public ObjectDecoder(ClassResolver classResolver) {
        this(0x100000, classResolver);
    }

    public ObjectDecoder(int maxObjectSize, ClassResolver classResolver) {
        super(maxObjectSize, 0, 4, 0, 4);
        this.classResolver = classResolver;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            return null;
        }
        CompactObjectInputStream is = new CompactObjectInputStream(new ByteBufInputStream(frame), this.classResolver);
        Object result = is.readObject();
        is.close();
        return result;
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

