/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.handler.codec.socks;

import java.util.List;
import org.testifyproject.netty.buffer.ByteBuf;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.handler.codec.ReplayingDecoder;
import org.testifyproject.netty.handler.codec.socks.SocksAuthRequest;
import org.testifyproject.netty.handler.codec.socks.SocksCommonUtils;
import org.testifyproject.netty.handler.codec.socks.SocksRequest;
import org.testifyproject.netty.handler.codec.socks.SocksSubnegotiationVersion;
import org.testifyproject.netty.util.CharsetUtil;

public class SocksAuthRequestDecoder
extends ReplayingDecoder<State> {
    private SocksSubnegotiationVersion version;
    private int fieldLength;
    private String username;
    private String password;
    private SocksRequest msg = SocksCommonUtils.UNKNOWN_SOCKS_REQUEST;

    public SocksAuthRequestDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksSubnegotiationVersion.valueOf(byteBuf.readByte());
                if (this.version != SocksSubnegotiationVersion.AUTH_PASSWORD) break;
                this.checkpoint(State.READ_USERNAME);
            }
            case READ_USERNAME: {
                this.fieldLength = byteBuf.readByte();
                this.username = byteBuf.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                this.checkpoint(State.READ_PASSWORD);
            }
            case READ_PASSWORD: {
                this.fieldLength = byteBuf.readByte();
                this.password = byteBuf.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                this.msg = new SocksAuthRequest(this.username, this.password);
            }
        }
        ctx.pipeline().remove(this);
        out.add(this.msg);
    }

    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_USERNAME,
        READ_PASSWORD;

    }
}

