/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.handler.proxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.testifyproject.netty.buffer.ByteBuf;
import org.testifyproject.netty.buffer.Unpooled;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.channel.ChannelPipeline;
import org.testifyproject.netty.handler.codec.base64.Base64;
import org.testifyproject.netty.handler.codec.http.DefaultFullHttpRequest;
import org.testifyproject.netty.handler.codec.http.HttpClientCodec;
import org.testifyproject.netty.handler.codec.http.HttpHeaderNames;
import org.testifyproject.netty.handler.codec.http.HttpMethod;
import org.testifyproject.netty.handler.codec.http.HttpResponse;
import org.testifyproject.netty.handler.codec.http.HttpResponseStatus;
import org.testifyproject.netty.handler.codec.http.HttpVersion;
import org.testifyproject.netty.handler.codec.http.LastHttpContent;
import org.testifyproject.netty.handler.proxy.ProxyConnectException;
import org.testifyproject.netty.handler.proxy.ProxyHandler;
import org.testifyproject.netty.util.AsciiString;
import org.testifyproject.netty.util.CharsetUtil;

public final class HttpProxyHandler
extends ProxyHandler {
    private static final String PROTOCOL = "http";
    private static final String AUTH_BASIC = "basic";
    private final HttpClientCodec codec = new HttpClientCodec();
    private final String username;
    private final String password;
    private final CharSequence authorization;
    private HttpResponseStatus status;

    public HttpProxyHandler(SocketAddress proxyAddress) {
        super(proxyAddress);
        this.username = null;
        this.password = null;
        this.authorization = null;
    }

    public HttpProxyHandler(SocketAddress proxyAddress, String username, String password) {
        super(proxyAddress);
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        this.username = username;
        this.password = password;
        ByteBuf authz = Unpooled.copiedBuffer(username + ':' + password, CharsetUtil.UTF_8);
        ByteBuf authzBase64 = Base64.encode(authz, false);
        this.authorization = new AsciiString("Basic " + authzBase64.toString(CharsetUtil.US_ASCII));
        authz.release();
        authzBase64.release();
    }

    @Override
    public String protocol() {
        return PROTOCOL;
    }

    @Override
    public String authScheme() {
        return this.authorization != null ? AUTH_BASIC : "none";
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    @Override
    protected void addCodec(ChannelHandlerContext ctx) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        String name = ctx.name();
        p.addBefore(name, null, this.codec);
    }

    @Override
    protected void removeEncoder(ChannelHandlerContext ctx) throws Exception {
        this.codec.removeOutboundHandler();
    }

    @Override
    protected void removeDecoder(ChannelHandlerContext ctx) throws Exception {
        this.codec.removeInboundHandler();
    }

    @Override
    protected Object newInitialMessage(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress raddr = (InetSocketAddress)this.destinationAddress();
        String rhost = raddr.isUnresolved() ? raddr.getHostString() : raddr.getAddress().getHostAddress();
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.CONNECT, rhost + ':' + raddr.getPort(), Unpooled.EMPTY_BUFFER, false);
        Object proxyAddress = this.proxyAddress();
        if (proxyAddress instanceof InetSocketAddress) {
            InetSocketAddress hostAddr = (InetSocketAddress)proxyAddress;
            req.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(hostAddr.getHostString() + ':' + hostAddr.getPort()));
        }
        if (this.authorization != null) {
            req.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)this.authorization);
        }
        return req;
    }

    @Override
    protected boolean handleResponse(ChannelHandlerContext ctx, Object response) throws Exception {
        boolean finished;
        if (response instanceof HttpResponse) {
            if (this.status != null) {
                throw new ProxyConnectException(this.exceptionMessage("too many responses"));
            }
            this.status = ((HttpResponse)response).status();
        }
        if (finished = response instanceof LastHttpContent) {
            if (this.status == null) {
                throw new ProxyConnectException(this.exceptionMessage("missing response"));
            }
            if (this.status.code() != 200) {
                throw new ProxyConnectException(this.exceptionMessage("status: " + this.status));
            }
        }
        return finished;
    }
}

