/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.repackaged.com.google.common.hash;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.testifyproject.repackaged.com.google.common.base.Preconditions;
import org.testifyproject.repackaged.com.google.common.hash.AbstractHasher;
import org.testifyproject.repackaged.com.google.common.hash.HashCode;
import org.testifyproject.repackaged.com.google.common.hash.HashFunction;
import org.testifyproject.repackaged.com.google.common.hash.Hasher;

abstract class AbstractStreamingHashFunction
implements HashFunction {
    AbstractStreamingHashFunction() {
    }

    @Override
    public HashCode hashLong(long input) {
        return this.newHasher().putLong(input).hash();
    }

    protected static abstract class AbstractStreamingHasher
    extends AbstractHasher {
        private final ByteBuffer buffer;
        private final int bufferSize;
        private final int chunkSize;

        protected AbstractStreamingHasher(int chunkSize) {
            this(chunkSize, chunkSize);
        }

        protected AbstractStreamingHasher(int chunkSize, int bufferSize) {
            Preconditions.checkArgument(bufferSize % chunkSize == 0);
            this.buffer = ByteBuffer.allocate(bufferSize + 7).order(ByteOrder.LITTLE_ENDIAN);
            this.bufferSize = bufferSize;
            this.chunkSize = chunkSize;
        }

        protected abstract void process(ByteBuffer var1);

        protected void processRemaining(ByteBuffer bb) {
            bb.position(bb.limit());
            bb.limit(this.chunkSize + 7);
            while (bb.position() < this.chunkSize) {
                bb.putLong(0L);
            }
            bb.limit(this.chunkSize);
            bb.flip();
            this.process(bb);
        }

        @Override
        public final Hasher putLong(long l) {
            this.buffer.putLong(l);
            this.munchIfFull();
            return this;
        }

        @Override
        public final HashCode hash() {
            this.munch();
            this.buffer.flip();
            if (this.buffer.remaining() > 0) {
                this.processRemaining(this.buffer);
            }
            return this.makeHash();
        }

        abstract HashCode makeHash();

        private void munchIfFull() {
            if (this.buffer.remaining() < 8) {
                this.munch();
            }
        }

        private void munch() {
            this.buffer.flip();
            while (this.buffer.remaining() >= this.chunkSize) {
                this.process(this.buffer);
            }
            this.buffer.compact();
        }
    }
}

