/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.tukaani.xz.index;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.testifyproject.tukaani.xz.CorruptedInputException;
import org.testifyproject.tukaani.xz.MemoryLimitException;
import org.testifyproject.tukaani.xz.SeekableInputStream;
import org.testifyproject.tukaani.xz.UnsupportedOptionsException;
import org.testifyproject.tukaani.xz.common.DecoderUtil;
import org.testifyproject.tukaani.xz.common.StreamFlags;
import org.testifyproject.tukaani.xz.index.BlockInfo;
import org.testifyproject.tukaani.xz.index.IndexBase;

public class IndexDecoder
extends IndexBase {
    private final BlockInfo info = new BlockInfo();
    private final long streamPadding;
    private final int memoryUsage;
    private final long[] unpadded;
    private final long[] uncompressed;
    private long largestBlockSize = 0L;
    private int pos = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndexDecoder(SeekableInputStream seekableInputStream, StreamFlags streamFlags, long l, int n) throws IOException {
        super(new CorruptedInputException("XZ Index is corrupt"));
        int n2;
        this.info.streamFlags = streamFlags;
        this.streamPadding = l;
        long l2 = seekableInputStream.position() + streamFlags.backwardSize - 4L;
        CRC32 cRC32 = new CRC32();
        CheckedInputStream checkedInputStream = new CheckedInputStream(seekableInputStream, cRC32);
        if (checkedInputStream.read() != 0) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        try {
            long l3 = DecoderUtil.decodeVLI(checkedInputStream);
            if (l3 >= streamFlags.backwardSize / 2L) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            if (l3 > Integer.MAX_VALUE) {
                throw new UnsupportedOptionsException("XZ Index has over 2147483647 Records");
            }
            this.memoryUsage = 1 + (int)((16L * l3 + 1023L) / 1024L);
            if (n >= 0 && this.memoryUsage > n) {
                throw new MemoryLimitException(this.memoryUsage, n);
            }
            this.unpadded = new long[(int)l3];
            this.uncompressed = new long[(int)l3];
            int n3 = 0;
            for (n2 = (int)l3; n2 > 0; --n2) {
                long l4 = DecoderUtil.decodeVLI(checkedInputStream);
                long l5 = DecoderUtil.decodeVLI(checkedInputStream);
                if (seekableInputStream.position() > l2) {
                    throw new CorruptedInputException("XZ Index is corrupt");
                }
                this.unpadded[n3] = this.blocksSum + l4;
                this.uncompressed[n3] = this.uncompressedSum + l5;
                super.add(l4, l5);
                if (!$assertionsDisabled && (long)(++n3) != this.recordCount) {
                    throw new AssertionError();
                }
                if (this.largestBlockSize >= l5) continue;
                this.largestBlockSize = l5;
            }
        }
        catch (EOFException eOFException) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        int n4 = this.getIndexPaddingSize();
        if (seekableInputStream.position() + (long)n4 != l2) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        while (n4-- > 0) {
            if (checkedInputStream.read() == 0) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        long l6 = cRC32.getValue();
        for (n2 = 0; n2 < 4; ++n2) {
            if ((l6 >>> n2 * 8 & 0xFFL) == (long)seekableInputStream.read()) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
    }

    public BlockInfo locate(long l) {
        if (!$assertionsDisabled && l >= this.uncompressedSum) {
            throw new AssertionError();
        }
        int n = 0;
        int n2 = this.unpadded.length - 1;
        while (n < n2) {
            int n3 = n + (n2 - n) / 2;
            if (this.uncompressed[n3] <= l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        this.pos = n;
        return this.getInfo();
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public long getStreamAndPaddingSize() {
        return this.getStreamSize() + this.streamPadding;
    }

    public long getUncompressedSize() {
        return this.uncompressedSum;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public boolean hasNext() {
        return (long)(this.pos + 1) < this.recordCount;
    }

    public BlockInfo getNext() {
        ++this.pos;
        return this.getInfo();
    }

    private BlockInfo getInfo() {
        if (this.pos == 0) {
            this.info.compressedOffset = 0L;
            this.info.uncompressedOffset = 0L;
        } else {
            this.info.compressedOffset = this.unpadded[this.pos - 1] + 3L & 0xFFFFFFFFFFFFFFFCL;
            this.info.uncompressedOffset = this.uncompressed[this.pos - 1];
        }
        this.info.unpaddedSize = this.unpadded[this.pos] - this.info.compressedOffset;
        this.info.uncompressedSize = this.uncompressed[this.pos] - this.info.uncompressedOffset;
        this.info.compressedOffset += 12L;
        return this.info;
    }

    static {
        $assertionsDisabled = !IndexDecoder.class.desiredAssertionStatus();
    }
}

