/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.junit4.system;

import java.net.URI;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.testifyproject.ServerInstance;
import org.testifyproject.ServerProvider;
import org.testifyproject.TestConfigurer;
import org.testifyproject.TestContext;
import org.testifyproject.TestDescriptor;
import org.testifyproject.annotation.Module;
import org.testifyproject.core.DefaultServerInstance;
import org.testifyproject.core.TestContextHolder;
import org.testifyproject.core.util.ExceptionUtil;
import org.testifyproject.core.util.LoggingUtil;
import org.testifyproject.core.util.ReflectionUtil;
import org.testifyproject.guava.common.collect.ImmutableSet;
import org.testifyproject.junit4.system.ApplicationContextInterceptor;
import org.testifyproject.junit4.system.SpringApplicationInterceptor;

public class SpringBootServerProvider
implements ServerProvider<SpringApplicationBuilder, EmbeddedServletContainer> {
    private static final String DEFAULT_URI_FORMAT = "http://0.0.0.0:%d%s";
    private static final TestContextHolder TEST_CONTEXT_HOLDER = TestContextHolder.INSTANCE;

    public SpringApplicationBuilder configure(TestContext testContext) {
        TestDescriptor testDescriptor = testContext.getTestDescriptor();
        TestConfigurer testConfigurer = testContext.getTestConfigurer();
        LoggingUtil.INSTANCE.debug("setting test context", new Object[0]);
        TEST_CONTEXT_HOLDER.set(testContext);
        SpringApplicationInterceptor springApplicationInterceptor = new SpringApplicationInterceptor(TEST_CONTEXT_HOLDER);
        ClassLoader classLoader = testDescriptor.getTestClassLoader();
        String applicationClassName = "org.springframework.boot.SpringApplication";
        ReflectionUtil.INSTANCE.rebase(applicationClassName, classLoader, (Object)springApplicationInterceptor);
        ApplicationContextInterceptor applicationContextInterceptor = new ApplicationContextInterceptor(TEST_CONTEXT_HOLDER);
        String applicationContextClassName = "org.springframework.boot.context.embedded.EmbeddedWebApplicationContext";
        ReflectionUtil.INSTANCE.rebase(applicationContextClassName, classLoader, (Object)applicationContextInterceptor);
        Optional foundApplication = testDescriptor.getApplication();
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[0]);
        foundApplication.ifPresent(application -> {
            ImmutableSet.Builder sourcesBuilder = ImmutableSet.builder().add((Object)application.value());
            ((Stream)testDescriptor.getModules().stream().sequential()).map(Module::value).forEach(arg_0 -> ((ImmutableSet.Builder)sourcesBuilder).add(arg_0));
            ImmutableSet sources = sourcesBuilder.build();
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader(classLoader);
            builder.sources(sources.toArray()).resourceLoader((ResourceLoader)resourceLoader).bannerMode(Banner.Mode.OFF);
        });
        return (SpringApplicationBuilder)testConfigurer.configure(testContext, (Object)builder);
    }

    public ServerInstance<EmbeddedServletContainer> start(TestContext testContext, SpringApplicationBuilder configuration) {
        LoggingUtil.INSTANCE.debug("starting spring boot application", new Object[0]);
        SpringApplication application = configuration.build();
        testContext.addProperty("app", (Object)application);
        testContext.addProperty("app.name", (Object)testContext.getName());
        LoggingUtil.INSTANCE.debug("running spring boot application", new Object[0]);
        application.run(new String[0]);
        Optional servletContext = testContext.findProperty("app.servlet.context");
        Optional servletContainer = testContext.findProperty("app.servlet.container");
        if (servletContext.isPresent() && servletContainer.isPresent()) {
            EmbeddedServletContainer container = (EmbeddedServletContainer)servletContainer.get();
            ServletContext context = (ServletContext)servletContext.get();
            String uri = String.format(DEFAULT_URI_FORMAT, container.getPort(), context.getContextPath());
            URI baseURI = URI.create(uri);
            LoggingUtil.INSTANCE.debug("creating spring boot application server instance", new Object[0]);
            return DefaultServerInstance.of((URI)baseURI, (Object)container);
        }
        throw ExceptionUtil.INSTANCE.propagate("servlet context and container not found", new Object[0]);
    }

    public void stop(TestContext testContext, ServerInstance<EmbeddedServletContainer> serverInstance) {
        LoggingUtil.INSTANCE.debug("Stopping spring application", new Object[0]);
        EmbeddedServletContainer container = (EmbeddedServletContainer)serverInstance.getValue();
        LoggingUtil.INSTANCE.debug("Stopping spring boot application servlet container", new Object[0]);
        container.stop();
    }
}

