/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.junit4.system;

import java.net.URI;
import java.util.Optional;
import javax.servlet.ServletContext;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.testifyproject.ServerInstance;
import org.testifyproject.ServerProvider;
import org.testifyproject.TestContext;
import org.testifyproject.TestDescriptor;
import org.testifyproject.annotation.Application;
import org.testifyproject.core.ServerInstanceBuilder;
import org.testifyproject.core.util.ExceptionUtil;
import org.testifyproject.core.util.LoggingUtil;

public class SpringBootServerProvider
implements ServerProvider<SpringApplicationBuilder, EmbeddedServletContainer> {
    private static final String DEFAULT_URI_FORMAT = "http://0.0.0.0:%d%s";

    public SpringApplicationBuilder configure(TestContext testContext) {
        TestDescriptor testDescriptor = testContext.getTestDescriptor();
        ClassLoader classLoader = testDescriptor.getTestClassLoader();
        Optional foundApplication = testDescriptor.getApplication();
        SpringApplicationBuilder applicationBuilder = new SpringApplicationBuilder(new Object[0]);
        foundApplication.ifPresent(application -> applicationBuilder.sources(new Class[]{application.value()}).resourceLoader((ResourceLoader)new DefaultResourceLoader(classLoader)).bannerMode(Banner.Mode.OFF));
        return applicationBuilder;
    }

    public ServerInstance<EmbeddedServletContainer> start(TestContext testContext, Application application, SpringApplicationBuilder configuration) {
        LoggingUtil.INSTANCE.debug("Starting Spring Boot application '{}'", new Object[]{testContext.getName()});
        SpringApplication springApplication = configuration.build();
        springApplication.run(new String[0]);
        Optional servletContext = testContext.findProperty("servletContext");
        Optional servletContainer = testContext.findProperty("appServer");
        if (servletContext.isPresent() && servletContainer.isPresent()) {
            EmbeddedServletContainer server = (EmbeddedServletContainer)servletContainer.get();
            ServletContext context = (ServletContext)servletContext.get();
            String uri = String.format(DEFAULT_URI_FORMAT, server.getPort(), context.getContextPath());
            URI baseURI = URI.create(uri);
            return ServerInstanceBuilder.builder().baseURI(baseURI).server((Object)server).property("app", (Object)springApplication).property("appName", (Object)testContext.getName()).property("appServer", (Object)server).build("springboot", application);
        }
        throw ExceptionUtil.INSTANCE.propagate("Could not start springboot application due to missing servlet container", new Object[0]);
    }

    public void stop(ServerInstance<EmbeddedServletContainer> serverInstance) {
        if (serverInstance != null) {
            serverInstance.command((container, baseURI) -> {
                LoggingUtil.INSTANCE.debug("Stopping Spring Boot server", new Object[0]);
                container.stop();
            });
        }
    }

    public Class<EmbeddedServletContainer> getServerType() {
        return EmbeddedServletContainer.class;
    }
}

