/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.junit4.system;

import java.util.concurrent.Callable;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionDefaults;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.testifyproject.ServiceProvider;
import org.testifyproject.TestConfigurer;
import org.testifyproject.TestDescriptor;
import org.testifyproject.annotation.Module;
import org.testifyproject.annotation.Scan;
import org.testifyproject.bytebuddy.implementation.bind.annotation.AllArguments;
import org.testifyproject.bytebuddy.implementation.bind.annotation.BindingPriority;
import org.testifyproject.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.testifyproject.bytebuddy.implementation.bind.annotation.SuperCall;
import org.testifyproject.bytebuddy.implementation.bind.annotation.This;
import org.testifyproject.core.TestContextHolder;
import org.testifyproject.core.util.ServiceLocatorUtil;
import org.testifyproject.di.spring.SpringBeanFactoryPostProcessor;
import org.testifyproject.di.spring.SpringServiceProvider;

public class ApplicationContextInterceptor {
    @RuntimeType
    @BindingPriority(value=0x7FFFFFFF)
    public Object anyMethod(@SuperCall Callable<?> zuper, @This(optional=true) Object object, @AllArguments Object[] args) throws Exception {
        return zuper.call();
    }

    public ConfigurableListableBeanFactory obtainFreshBeanFactory(@SuperCall Callable<ConfigurableListableBeanFactory> zuper, @This Object applicationContext, @AllArguments Object[] args) throws Exception {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)zuper.call();
        TestContextHolder.INSTANCE.command(testContext -> {
            AnnotationConfigWebApplicationContext configuredContext = (AnnotationConfigWebApplicationContext)applicationContext;
            if (applicationContext instanceof AnnotationConfigWebApplicationContext) {
                configuredContext.setId(testContext.getName());
                configuredContext.setDisplayName(testContext.getName());
                configuredContext.setAllowCircularReferences(false);
                configuredContext.setAllowBeanDefinitionOverriding(true);
            }
            SpringBeanFactoryPostProcessor postProcessor = new SpringBeanFactoryPostProcessor(testContext);
            configuredContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)postProcessor);
            TestConfigurer testConfigurer = testContext.getTestConfigurer();
            ConfigurableApplicationContext configuredApplicationContext = (ConfigurableApplicationContext)testConfigurer.configure(testContext, (Object)configuredContext);
            TestDescriptor testDescriptor = testContext.getTestDescriptor();
            ConfigurableEnvironment environment = configuredContext.getEnvironment();
            this.addModules(testDescriptor, environment, beanFactory);
            this.addScans(testDescriptor, environment, beanFactory);
            testContext.computeIfAbsent("serviceInstance", key -> {
                ServiceProvider serviceProvider = (ServiceProvider)ServiceLocatorUtil.INSTANCE.getOne(ServiceProvider.class, SpringServiceProvider.class);
                return serviceProvider.configure(testContext, (Object)configuredApplicationContext);
            });
        });
        return beanFactory;
    }

    void addModules(TestDescriptor testDescriptor, ConfigurableEnvironment environment, DefaultListableBeanFactory beanFactory) {
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)beanFactory, (Environment)environment);
        testDescriptor.getModules().stream().map(Module::value).forEachOrdered(arg_0 -> ((AnnotatedBeanDefinitionReader)reader).registerBean(arg_0));
    }

    void addScans(TestDescriptor testDescriptor, ConfigurableEnvironment environment, DefaultListableBeanFactory beanFactory) {
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)beanFactory, true, (Environment)environment);
        BeanDefinitionDefaults beanDefinitionDefaults = scanner.getBeanDefinitionDefaults();
        beanDefinitionDefaults.setLazyInit(true);
        testDescriptor.getScans().stream().map(Scan::value).forEachOrdered(xva$0 -> scanner.scan(new String[]{xva$0}));
    }
}

