/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.junit4.system;

import java.util.Optional;
import javax.servlet.ServletContainerInitializer;
import org.springframework.web.SpringServletContainerInitializer;
import org.testifyproject.ApplicationInstance;
import org.testifyproject.ApplicationProvider;
import org.testifyproject.TestContext;
import org.testifyproject.TestDescriptor;
import org.testifyproject.annotation.Application;
import org.testifyproject.core.DefaultApplicationInstance;
import org.testifyproject.core.util.InstrumentUtil;
import org.testifyproject.junit4.system.SpringApplicationInterceptor;
import org.testifyproject.server.core.ServletInstance;

public class SpringApplicationProvider
implements ApplicationProvider {
    public ApplicationInstance start(TestContext testContext) {
        TestDescriptor testDescriptor = testContext.getTestDescriptor();
        Optional foundApplication = testDescriptor.getApplication();
        ApplicationInstance applicationInstance = null;
        if (foundApplication.isPresent()) {
            Application application = (Application)foundApplication.get();
            SpringApplicationInterceptor interceptor = new SpringApplicationInterceptor();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class dynamicApp = InstrumentUtil.INSTANCE.createSubclass(application.value(), classLoader, (Object)interceptor);
            SpringServletContainerInitializer initializer = new SpringServletContainerInitializer();
            ServletInstance servletInstance = ServletInstance.builder().handler(dynamicApp).initializer((ServletContainerInitializer)initializer).build();
            applicationInstance = DefaultApplicationInstance.of((TestContext)testContext, (Application)application);
            applicationInstance.addProperty("servletInstance", (Object)servletInstance);
        }
        return applicationInstance;
    }
}

