/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.util.Enumeration;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testresultinterface.LogFileXmlHandler;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.TestInterface;
import org.testtoolinterfaces.testsuite.TestInterfaceList;
import org.testtoolinterfaces.testsuite.TestStep;
import org.testtoolinterfaces.testsuite.TestStepCommand;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class ActionTypeResultXmlHandler
extends XmlHandler {
    public static final String PARAM_SEQUENCE = "sequence";
    public static final String PARAM_INTERFACE = "interface";
    private static final String COMMAND_ELEMENT = "command";
    private static final String RESULT_ELEMENT = "result";
    private GenericTagAndStringXmlHandler myCommandXmlHandler;
    private GenericTagAndStringXmlHandler myResultXmlHandler;
    private LogFileXmlHandler myLogFileXmlHandler;
    private TestInterfaceList myInterfaceList;
    private int mySequence = 0;
    private TestInterface myInterface;
    private String myCommand = "";
    private TestResult.VERDICT myResult = TestResult.UNKNOWN;
    private Hashtable<String, String> myLogFiles = new Hashtable();

    public ActionTypeResultXmlHandler(XMLReader anXmlReader, String aTag, TestInterfaceList anInterfaceList) {
        super(anXmlReader, aTag);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR, (String)("ActionTypeResultXmlHandler( anXmlreader, " + aTag + " )"), (boolean)true);
        this.myInterfaceList = anInterfaceList;
        this.myInterface = anInterfaceList.getInterface("Unknown");
        this.myCommandXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, COMMAND_ELEMENT);
        this.addElementHandler(COMMAND_ELEMENT, (XmlHandler)this.myCommandXmlHandler);
        this.myResultXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, RESULT_ELEMENT);
        this.addElementHandler(RESULT_ELEMENT, (XmlHandler)this.myResultXmlHandler);
        this.myLogFileXmlHandler = new LogFileXmlHandler(anXmlReader);
        this.addElementHandler("logfile", (XmlHandler)this.myLogFileXmlHandler);
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
        Trace.println((Trace.LEVEL)Trace.SUITE, (String)("processElementAttributes( " + aQualifiedName + " )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(this.getStartElement())) {
            for (int i = 0; i < att.getLength(); ++i) {
                if (att.getQName(i).equalsIgnoreCase(PARAM_SEQUENCE)) {
                    this.mySequence = Integer.valueOf(att.getValue(i));
                    Trace.println((Trace.LEVEL)Trace.ALL, (String)("        mySequence -> " + this.mySequence));
                    continue;
                }
                if (!att.getQName(i).equalsIgnoreCase(PARAM_INTERFACE)) continue;
                String interfaceName = att.getValue(i);
                this.myInterface = this.myInterfaceList.getInterface(interfaceName);
                Trace.println((Trace.LEVEL)Trace.ALL, (String)("        myInterface -> " + this.myInterface.getInterfaceName()));
            }
        }
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        if (aQualifiedName.equalsIgnoreCase(COMMAND_ELEMENT)) {
            this.myCommand = this.myCommandXmlHandler.getValue();
            this.myCommandXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(RESULT_ELEMENT)) {
            this.myResult = TestResult.VERDICT.valueOf((String)this.myResultXmlHandler.getValue().toUpperCase());
            this.myResultXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("logfile")) {
            this.myLogFiles.put(this.myLogFileXmlHandler.getType(), this.myLogFileXmlHandler.getValue());
            this.myLogFileXmlHandler.reset();
        }
    }

    public TestStepResult getActionStep() {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        TestStepCommand testStep = new TestStepCommand(this.mySequence, "", this.myCommand, this.myInterface, new ParameterArrayList());
        TestStepResult testStepResult = new TestStepResult((TestStep)testStep);
        testStepResult.setResult(this.myResult);
        if (!this.myLogFiles.isEmpty()) {
            Enumeration<String> keys = this.myLogFiles.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                testStepResult.addTestLog(key, this.myLogFiles.get(key));
            }
        }
        return testStepResult;
    }

    public void reset() {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        this.mySequence = 0;
    }
}

