/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.TestCaseResult;
import org.testtoolinterfaces.testresult.TestCaseResultObserver;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testresultinterface.Configuration;
import org.testtoolinterfaces.testresultinterface.TestCaseResultWriter;
import org.testtoolinterfaces.testresultinterface.TestStepResultXmlWriter;
import org.testtoolinterfaces.testresultinterface.XmlWriterUtils;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.Warning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseResultXmlWriter
implements TestCaseResultWriter {
    private File myXslDir;
    private File myResultFile;
    TestStepResultXmlWriter myTsResultWriter;

    public TestCaseResultXmlWriter(Configuration aConfiguration) {
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR, (String)"TestCaseResultXmlWriter( aConfiguration )", (boolean)true);
        this.myXslDir = aConfiguration.getCaseXslDir();
        if (this.myXslDir == null) {
            throw new Error("No directory specified.");
        }
        if (!this.myXslDir.isDirectory()) {
            throw new Error("Not a directory: " + this.myXslDir.getPath());
        }
        this.myTsResultWriter = new TestStepResultXmlWriter();
    }

    @Override
    public void write(TestCaseResult aTestCaseResult, File aResultFile) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("write( " + aResultFile.getPath() + " )"), (boolean)true);
        if (aTestCaseResult == null) {
            return;
        }
        this.myResultFile = aResultFile;
        this.writeToFile(aTestCaseResult, aResultFile);
        aTestCaseResult.register((TestCaseResultObserver)this);
    }

    public void notify(TestCaseResult aTestCaseResult) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("notify( " + aTestCaseResult.getId() + " )"), (boolean)true);
        this.writeToFile(aTestCaseResult, this.myResultFile);
    }

    private void writeToFile(TestCaseResult aTestCaseResult, File aResultFile) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("writeToFile( " + aTestCaseResult.getId() + ", " + aResultFile.getPath() + " )"), (boolean)true);
        File logDir = aResultFile.getParentFile();
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        XmlWriterUtils.copyXsl(this.myXslDir, logDir);
        try {
            FileWriter xmlFile = new FileWriter(aResultFile);
            XmlWriterUtils.printXmlDeclaration(xmlFile, "testcase.xsl");
            xmlFile.write("<testcase\n");
            xmlFile.write("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            xmlFile.write("    xsi:noNamespaceSchemaLocation=\"TestResult_Case.xsd\"\n");
            xmlFile.write("    xsdMain='0'\n");
            xmlFile.write("    xsdSub='2'\n");
            xmlFile.write("    xsdPatch='0'\n");
            xmlFile.write("    id='" + aTestCaseResult.getId() + "'\n");
            xmlFile.write("    sequence='" + aTestCaseResult.getSequenceNr() + "'\n");
            xmlFile.write(">\n");
            this.printDescription(xmlFile, aTestCaseResult.getDescription(), "");
            this.printRequirements(xmlFile, aTestCaseResult.getRequirements(), "");
            xmlFile.write("  <prepare>\n");
            this.printStepResults(xmlFile, aTestCaseResult.getPrepareResults(), logDir);
            xmlFile.write("  </prepare>\n");
            xmlFile.write("  <execute>\n");
            this.printStepResults(xmlFile, aTestCaseResult.getExecutionResults(), logDir);
            xmlFile.write("  </execute>\n");
            xmlFile.write("  <restore>\n");
            this.printStepResults(xmlFile, aTestCaseResult.getRestoreResults(), logDir);
            xmlFile.write("  </restore>\n");
            xmlFile.write("  <result>" + aTestCaseResult.getResult().toString() + "</result>\n");
            XmlWriterUtils.printXmlLogFiles(aTestCaseResult.getLogs(), xmlFile, logDir.getAbsolutePath(), "  ");
            XmlWriterUtils.printXmlComment((TestResult)aTestCaseResult, xmlFile, "  ");
            xmlFile.write("</testcase>\n");
            xmlFile.flush();
        }
        catch (IOException exception) {
            Warning.println((String)("Saving Test Case Result XML failed: " + exception.getMessage()));
            Trace.print((Trace.LEVEL)Trace.SUITE, (Throwable)exception);
        }
    }

    private void printDescription(OutputStreamWriter aStream, String aDescription, String anIndent) throws IOException {
        aStream.write(anIndent + "  <description>");
        aStream.write(aDescription);
        aStream.write("</description>\n");
    }

    private void printRequirements(OutputStreamWriter aStream, ArrayList<String> aRequirementList, String anIndent) throws IOException {
        for (int key = 0; key < aRequirementList.size(); ++key) {
            XmlWriterUtils.printXmlRequirement(aStream, aRequirementList.get(key), anIndent + "  ");
        }
    }

    private void printStepResults(OutputStreamWriter aStream, Hashtable<Integer, TestStepResult> aStepResults, File aLogDir) throws IOException {
        for (int key = 0; key < aStepResults.size(); ++key) {
            this.myTsResultWriter.printXml(aStepResults.get(key), aStream, aLogDir);
        }
    }
}

