/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testresultinterface.XmlWriterUtils;
import org.testtoolinterfaces.testsuite.Parameter;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.ParameterHash;
import org.testtoolinterfaces.testsuite.ParameterImpl;
import org.testtoolinterfaces.testsuite.ParameterVariable;
import org.testtoolinterfaces.utils.Trace;

public class TestStepResultXmlWriter {
    TestStepResultXmlWriter mySubTestStepResultXmlWriter;

    public TestStepResultXmlWriter() {
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
    }

    public void printXml(TestStepResult aResult, OutputStreamWriter aStream, File aLogDir) throws IOException {
        String script;
        Trace.println((Trace.LEVEL)Trace.UTIL);
        aStream.write("    <teststep");
        aStream.write(" sequence='" + aResult.getSequenceNr() + "'");
        aStream.write(">\n");
        String description = aResult.getDescription();
        aStream.write("      <description>");
        aStream.write(description);
        aStream.write("</description>\n");
        String command = aResult.getCommand();
        if (!command.isEmpty()) {
            aStream.write("      <command>" + command + "</command>\n");
        }
        if (!(script = aResult.getScript()).isEmpty()) {
            aStream.write("      <script>" + script + "</script>\n");
        }
        this.printSubTestStep(aResult, aStream, aLogDir);
        aStream.write("      <result>" + aResult.getResult().toString() + "</result>\n");
        ParameterArrayList parameters = aResult.getParameters();
        ParameterArrayList params = parameters.sort();
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = (Parameter)params.get(i);
            aStream.write("      <parameter id='" + param.getName() + "' ");
            if (ParameterImpl.class.isInstance(param)) {
                aStream.write("type='value' sequence='" + param.getIndex() + "'>" + ((ParameterImpl)param).getValue().toString());
            } else if (ParameterVariable.class.isInstance(param)) {
                aStream.write("type='variable' sequence='" + param.getIndex() + "'>" + ((ParameterVariable)param).getVariableName());
            } else if (ParameterHash.class.isInstance(param)) {
                aStream.write("type='hash' sequence='" + param.getIndex() + "'>" + ((ParameterHash)param).size() + " sub-parameters");
            } else {
                aStream.write("type='unknown' sequence='" + param.getIndex() + "'>");
            }
            aStream.write("</parameter>\n");
        }
        String comment = aResult.getComment();
        if (!comment.isEmpty()) {
            aStream.write("      <comment>" + comment + "</comment>\n");
        }
        XmlWriterUtils.printXmlLogFiles(aResult.getLogs(), aStream, aLogDir.getAbsolutePath(), "  ");
        aStream.write("    </teststep>\n");
    }

    private void printSubTestStep(TestStepResult aResult, OutputStreamWriter aStream, File aLogDir) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        Hashtable subSteps = aResult.getSubSteps();
        if (subSteps.size() > 0) {
            aStream.write("      <substeps>\n");
            if (this.mySubTestStepResultXmlWriter == null) {
                this.mySubTestStepResultXmlWriter = new TestStepResultXmlWriter();
            }
            for (int key = 0; key < subSteps.size(); ++key) {
                TestStepResult tsResult = (TestStepResult)subSteps.get(key);
                if (tsResult == null) continue;
                this.mySubTestStepResultXmlWriter.printXml((TestStepResult)subSteps.get(key), aStream, aLogDir);
            }
            aStream.write("      </substeps>\n");
        }
    }
}

