/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.utils.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlWriterUtils {
    public static void printXmlDeclaration(OutputStreamWriter aStream, String aXslRef) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        aStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        aStream.write("<?xml-stylesheet type=\"text/xsl\" href=\"" + aXslRef + "\"?>\n\n");
    }

    public static void printXmlLogFiles(Hashtable<String, String> aLogs, OutputStreamWriter aStream, String aBaseLogDir, String anIndent) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("printXmlLogFiles( " + aLogs.size() + "logs, aStream, " + aBaseLogDir + ", " + anIndent + ")"), (boolean)true);
        if (!aLogs.isEmpty()) {
            Enumeration<String> keys = aLogs.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String logFile = new File(aLogs.get(key)).getCanonicalPath();
                logFile = XmlWriterUtils.makeFileRelative(logFile, new File(aBaseLogDir).getCanonicalPath());
                aStream.write(anIndent + "  <logfile");
                aStream.write(" type='" + key + "'");
                aStream.write(">" + logFile);
                aStream.write("</logfile>\n");
            }
        }
    }

    public static String makeFileRelative(String aLogFile, String aBaseLogDir) {
        if (aLogFile.startsWith(aBaseLogDir) && (aLogFile = aLogFile.substring(aBaseLogDir.length())).startsWith(File.separator)) {
            aLogFile = aLogFile.substring(File.separator.length());
        }
        aLogFile = aLogFile.replace('\\', '/');
        return aLogFile;
    }

    public static void printXmlComment(TestResult aTestResult, OutputStreamWriter aStream, String anIndent) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        String comment = aTestResult.getComment();
        if (!comment.isEmpty()) {
            aStream.write(anIndent + "<comment>");
            aStream.write(comment);
            aStream.write("</comment>\n");
        }
    }

    public static void printXmlRequirement(OutputStreamWriter aStream, String aRequirementId, String anIndent) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        aStream.write(anIndent + "<requirementid>");
        aStream.write(aRequirementId);
        aStream.write("</requirementid>\n");
    }

    public static void copyXsl(File aSourceDir, File aTargetLogDir) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("copyXsl( " + aTargetLogDir.getName() + " )"), (boolean)true);
        if (aSourceDir == null) {
            return;
        }
        File[] files = aSourceDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File srcFile = files[i];
            if (srcFile.isDirectory()) continue;
            File tgtFile = new File(aTargetLogDir + File.separator + srcFile.getName());
            FileChannel inChannel = null;
            AbstractInterruptibleChannel outChannel = null;
            try {
                inChannel = new FileInputStream(srcFile).getChannel();
                outChannel = new FileOutputStream(tgtFile).getChannel();
                inChannel.transferTo(0L, inChannel.size(), (WritableByteChannel)((Object)outChannel));
                continue;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            finally {
                if (inChannel != null) {
                    try {
                        inChannel.close();
                    }
                    catch (IOException exc) {
                        throw new IOError(exc);
                    }
                }
                if (outChannel != null) {
                    try {
                        outChannel.close();
                    }
                    catch (IOException exc) {
                        throw new IOError(exc);
                    }
                }
            }
        }
    }
}

