/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.TestCaseResultLink;
import org.testtoolinterfaces.testresult.TestGroupResult;
import org.testtoolinterfaces.testresult.TestGroupResultLink;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testresultinterface.LogFileXmlHandler;
import org.testtoolinterfaces.testresultinterface.SummaryResultXmlHandler;
import org.testtoolinterfaces.testresultinterface.TestCaseResultLinkXmlHandler;
import org.testtoolinterfaces.testresultinterface.TestGroupResultLinkXmlHandler;
import org.testtoolinterfaces.testresultinterface.TestStepSequenceResultXmlHandler;
import org.testtoolinterfaces.testsuite.TestGroup;
import org.testtoolinterfaces.testsuite.TestGroupImpl;
import org.testtoolinterfaces.testsuite.TestInterfaceList;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

public class TestGroupResultXmlHandler
extends XmlHandler {
    public static final String START_ELEMENT = "testgroup";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_STARTDATE = "startdate";
    private static final String ATTRIBUTE_STARTTIME = "starttime";
    private static final String ATTRIBUTE_ENDDATE = "enddate";
    private static final String ATTRIBUTE_ENDTIME = "endtime";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_REQUIREMENT = "requirement";
    private static final String ELEMENT_PREPARE = "prepare";
    private static final String ELEMENT_RESTORE = "restore";
    private String myTestGroupId;
    private int myCurrentSequence;
    private String myDescription;
    private ArrayList<String> myRequirements;
    private TestResult.VERDICT myResult;
    private String myComment;
    private Hashtable<String, String> myLogFiles;
    private ArrayList<TestStepResult> myPrepareSteps;
    private ArrayList<TestCaseResultLink> myTestCaseResultLinks;
    private ArrayList<TestGroupResultLink> myTestGroupResultLinks;
    private ArrayList<TestStepResult> myRestoreSteps;
    private GenericTagAndStringXmlHandler myDescriptionXmlHandler;
    private GenericTagAndStringXmlHandler myRequirementIdXmlHandler;
    private TestStepSequenceResultXmlHandler myPrepareResultXmlHandler;
    private TestCaseResultLinkXmlHandler myTestCaseResultLinkXmlHandler;
    private TestGroupResultLinkXmlHandler myTestGroupResulLinkXmlHandler;
    private TestStepSequenceResultXmlHandler myRestoreResultXmlHandler;
    private SummaryResultXmlHandler mySummaryXmlHandler;
    private LogFileXmlHandler myLogFileXmlHandler;

    public TestGroupResultXmlHandler(XMLReader anXmlReader, TestInterfaceList anInterfaceList) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.reset();
        this.myDescriptionXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_DESCRIPTION);
        this.addElementHandler(ELEMENT_DESCRIPTION, (XmlHandler)this.myDescriptionXmlHandler);
        this.myRequirementIdXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_REQUIREMENT);
        this.addElementHandler(ELEMENT_REQUIREMENT, (XmlHandler)this.myRequirementIdXmlHandler);
        this.myPrepareResultXmlHandler = new TestStepSequenceResultXmlHandler(anXmlReader, ELEMENT_PREPARE, anInterfaceList);
        this.addElementHandler(ELEMENT_PREPARE, this.myPrepareResultXmlHandler);
        this.myTestCaseResultLinkXmlHandler = new TestCaseResultLinkXmlHandler(anXmlReader);
        this.addElementHandler("testcaselink", this.myTestCaseResultLinkXmlHandler);
        this.myTestGroupResulLinkXmlHandler = new TestGroupResultLinkXmlHandler(anXmlReader);
        this.addElementHandler("testgrouplink", this.myTestGroupResulLinkXmlHandler);
        this.myRestoreResultXmlHandler = new TestStepSequenceResultXmlHandler(anXmlReader, ELEMENT_RESTORE, anInterfaceList);
        this.addElementHandler(ELEMENT_RESTORE, this.myRestoreResultXmlHandler);
        this.mySummaryXmlHandler = new SummaryResultXmlHandler(anXmlReader);
        this.addElementHandler("summary", this.mySummaryXmlHandler);
        this.myLogFileXmlHandler = new LogFileXmlHandler(anXmlReader);
        this.addElementHandler("logfile", (XmlHandler)this.myLogFileXmlHandler);
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
        Trace.print((Trace.LEVEL)Trace.SUITE, (String)("processElementAttributes( " + aQualifiedName), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(START_ELEMENT)) {
            for (int i = 0; i < att.getLength(); ++i) {
                Trace.print((Trace.LEVEL)Trace.SUITE, (String)(", " + att.getQName(i) + "=" + att.getValue(i)));
                if (!att.getQName(i).equalsIgnoreCase(ATTRIBUTE_ID)) continue;
                this.myTestGroupId = att.getValue(i);
            }
        }
        Trace.println((Trace.LEVEL)Trace.SUITE, (String)" )");
    }

    public TestGroupResult getTestGroupResult() throws SAXParseException {
        int key;
        Trace.println((Trace.LEVEL)Trace.SUITE);
        if (this.myTestGroupId.isEmpty()) {
            throw new SAXParseException("Unknown TestCase ID", new LocatorImpl());
        }
        TestGroupImpl testGroup = new TestGroupImpl(this.myTestGroupId, this.myDescription, 0, this.myRequirements, null, null, null, new Hashtable(), new Hashtable());
        TestGroupResult testGroupResult = new TestGroupResult((TestGroup)testGroup);
        testGroupResult.setResult(this.myResult);
        testGroupResult.setComment(this.myComment);
        if (!this.myLogFiles.isEmpty()) {
            Enumeration<String> keys = this.myLogFiles.keys();
            while (keys.hasMoreElements()) {
                String key2 = keys.nextElement();
                testGroupResult.addTestLog(key2, this.myLogFiles.get(key2));
            }
        }
        for (key = 0; key < this.myPrepareSteps.size(); ++key) {
            testGroupResult.addInitialization(this.myPrepareSteps.get(key));
        }
        for (key = 0; key < this.myTestGroupResultLinks.size(); ++key) {
            testGroupResult.addTestGroup(this.myTestGroupResultLinks.get(key));
        }
        for (key = 0; key < this.myTestCaseResultLinks.size(); ++key) {
            testGroupResult.addTestCase(this.myTestCaseResultLinks.get(key));
        }
        for (key = 0; key < this.myRestoreSteps.size(); ++key) {
            testGroupResult.addRestore(this.myRestoreSteps.get(key));
        }
        return testGroupResult;
    }

    public int getSequence() {
        Trace.println((Trace.LEVEL)Trace.GETTER, (String)("getSequence() -> " + this.myCurrentSequence), (boolean)true);
        return this.myCurrentSequence;
    }

    public void reset() {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        this.myTestGroupId = "";
        this.myCurrentSequence = 0;
        this.myDescription = "";
        this.myRequirements = new ArrayList();
        this.myResult = TestResult.UNKNOWN;
        this.myComment = "";
        this.myLogFiles = new Hashtable();
        this.myPrepareSteps = new ArrayList();
        this.myTestGroupResultLinks = new ArrayList();
        this.myTestCaseResultLinks = new ArrayList();
        this.myRestoreSteps = new ArrayList();
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        if (aQualifiedName.equalsIgnoreCase(ELEMENT_DESCRIPTION)) {
            this.myDescription = this.myDescriptionXmlHandler.getValue();
            this.myDescriptionXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(ELEMENT_REQUIREMENT)) {
            this.myRequirements.add(this.myRequirementIdXmlHandler.getValue());
            this.myRequirementIdXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(ELEMENT_PREPARE)) {
            this.myPrepareSteps = this.myPrepareResultXmlHandler.getStepSequence();
            this.myPrepareResultXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("testcaselink")) {
            this.myTestCaseResultLinks.add(this.myTestCaseResultLinkXmlHandler.getTestCaseResultLink());
            this.myTestCaseResultLinkXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("testgrouplink")) {
            this.myTestGroupResultLinks.add(this.myTestGroupResulLinkXmlHandler.getTestGroupResultLink());
            this.myTestGroupResulLinkXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(ELEMENT_RESTORE)) {
            this.myRestoreSteps = this.myRestoreResultXmlHandler.getStepSequence();
            this.myRestoreResultXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("logfile")) {
            this.myLogFiles.put(this.myLogFileXmlHandler.getType(), this.myLogFileXmlHandler.getValue());
            this.myLogFileXmlHandler.reset();
        }
    }
}

