/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.TestGroupResult;
import org.testtoolinterfaces.testresult.TestRunResult;
import org.testtoolinterfaces.testresult.TestRunResultObserver;
import org.testtoolinterfaces.testresultinterface.Configuration;
import org.testtoolinterfaces.testresultinterface.TestGroupResultXmlWriter;
import org.testtoolinterfaces.testresultinterface.TestRunResultWriter;
import org.testtoolinterfaces.testresultinterface.XmlWriterUtils;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.Warning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunResultXmlWriter
implements TestRunResultWriter {
    private File myXslDir;
    private String myTestEnvironment = "Unknown";
    private String myTestPhase = "Unknown";
    private File myBaseLogDir;
    private File myResultFile;
    private TestGroupResultXmlWriter myTgResultWriter;

    public TestRunResultXmlWriter(Configuration aConfiguration, String anEnvironment, String aTestPhase) {
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR, (String)("TestRunResultXmlWriter( aConfiguration, " + anEnvironment + ", " + aTestPhase + " )"), (boolean)true);
        this.myXslDir = aConfiguration.getRunXslDir();
        if (this.myXslDir == null) {
            throw new Error("No directory specified.");
        }
        if (!this.myXslDir.isDirectory()) {
            throw new Error("Not a directory: " + this.myXslDir.getPath());
        }
        this.myTestEnvironment = anEnvironment;
        this.myTestPhase = aTestPhase;
        this.myTgResultWriter = new TestGroupResultXmlWriter(aConfiguration);
    }

    @Override
    public void write(TestRunResult aRunResult, File aFileName) {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        this.myResultFile = aFileName;
        if (aRunResult == null) {
            return;
        }
        this.writeToFile(aRunResult, aFileName);
        aRunResult.register((TestRunResultObserver)this);
    }

    public void notify(TestRunResult aRunResult) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("notify( " + aRunResult.getDisplayName() + " )"), (boolean)true);
        if (this.myResultFile == null) {
            Warning.println((String)"Cannot update a test-run file that is not yet written");
        } else {
            this.writeToFile(aRunResult, this.myResultFile);
        }
    }

    private void writeToFile(TestRunResult aRunResult, File aFileName) {
        File logDir = aFileName.getParentFile();
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        XmlWriterUtils.copyXsl(this.myXslDir, logDir);
        this.myBaseLogDir = logDir;
        try {
            FileWriter xmlFile = new FileWriter(aFileName);
            this.printXmlHeader(aRunResult, xmlFile, aFileName.getName());
            this.printXmlTestRuns(aRunResult, xmlFile);
            xmlFile.flush();
        }
        catch (IOException e) {
            Warning.println((String)("Saving Test Run Result XML failed: " + e.getMessage()));
            Trace.print((Trace.LEVEL)Trace.SUITE, (Throwable)e);
        }
    }

    public void printXmlHeader(TestRunResult aRunResult, OutputStreamWriter aStream, String aDocName) throws IOException {
        XmlWriterUtils.printXmlDeclaration(aStream, "testrun.xsl");
        aStream.write("<!--\n");
        aStream.write("    Document   : " + aDocName + "\n");
        aStream.write("    Created on : " + aRunResult.getStartDateString() + "\n");
        aStream.write("    Author     : " + aRunResult.getAuthor() + "\n");
        aStream.write("    Name       : " + aRunResult.getDisplayName() + "\n");
        aStream.write("-->\n");
    }

    public void printXmlTestRuns(TestRunResult aRunResult, OutputStreamWriter aStream) throws IOException {
        aStream.write("<testrun\n");
        aStream.write("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        aStream.write("    xsi:noNamespaceSchemaLocation=\"TestResult_Run.xsd\"\n");
        aStream.write("    xsdMain='0'\n");
        aStream.write("    xsdSub='2'\n");
        aStream.write("    xsdPatch='0'\n");
        aStream.write("    name='" + aRunResult.getDisplayName() + "'\n");
        aStream.write("    suite='" + aRunResult.getTestSuite() + "'\n");
        aStream.write("    environment='" + this.myTestEnvironment + "'\n");
        aStream.write("    phase='" + this.myTestPhase + "'\n");
        aStream.write("    author='" + aRunResult.getAuthor() + "'\n");
        aStream.write("    machine='" + aRunResult.getMachine() + "'\n");
        aStream.write("    status='" + aRunResult.getStatus() + "'\n");
        aStream.write("    startdate='" + aRunResult.getStartDateString() + "'\n");
        aStream.write("    starttime='" + aRunResult.getStartTimeString() + "'\n");
        aStream.write("    enddate='" + aRunResult.getEndDateString() + "'\n");
        aStream.write("    endtime='" + aRunResult.getEndTimeString() + "'\n");
        aStream.write("  >\n");
        this.printXmlSut(aRunResult, aStream);
        TestGroupResult tgResult = aRunResult.getTestGroup();
        if (tgResult != null) {
            this.myTgResultWriter.printXml(tgResult, aStream, "  ", this.myBaseLogDir);
        }
        aStream.write("</testrun>\n");
    }

    public void printXmlSut(TestRunResult aRunResult, OutputStreamWriter aStream) throws IOException {
        if (!aRunResult.getSutProduct().isEmpty()) {
            aStream.write("  <systemundertest");
            aStream.write(" product='" + aRunResult.getSutProduct() + "'");
            aStream.write(">\n");
            aStream.write("    <version");
            aStream.write(" main='" + aRunResult.getSutVersionMainLevel() + "'");
            aStream.write(" sub='" + aRunResult.getSutVersionSubLevel() + "'");
            aStream.write(" patch='" + aRunResult.getSutVersionPatchLevel() + "'");
            aStream.write(">\n");
            this.printXmlLogFiles(aRunResult.getSutLogs(), aStream);
            XmlWriterUtils.printXmlLogFiles(aRunResult.getSutLogs(), aStream, this.myBaseLogDir.getAbsolutePath(), "      ");
            aStream.write("    </version>\n");
            aStream.write("  </systemundertest>\n");
        }
    }

    public void printXmlLogFiles(Hashtable<String, String> aLogs, OutputStreamWriter aStream) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        if (!aLogs.isEmpty()) {
            Enumeration<String> keys = aLogs.keys();
            while (keys.hasMoreElements()) {
                String baseLogDir;
                String key = keys.nextElement();
                String logFile = new File(aLogs.get(key)).getCanonicalPath();
                if (logFile.startsWith(baseLogDir = this.myBaseLogDir.getCanonicalPath()) && (logFile = logFile.substring(baseLogDir.length())).startsWith(File.separator)) {
                    logFile = logFile.substring(File.separator.length());
                }
                logFile = logFile.replace('\\', '/');
                aStream.write("      <logfile");
                aStream.write(" id='" + key + "'");
                aStream.write(" type='text'");
                aStream.write(">" + logFile);
                aStream.write("</logfile>\n");
            }
        }
    }
}

