/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import org.testtoolinterfaces.testresult.ResultSummary;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class SummaryResultXmlHandler
extends XmlHandler {
    public static final String ELEMENT_START = "summary";
    private static final String ELEMENT_TOTAL = "totaltestcases";
    private static final String ELEMENT_PASSED = "totalpassed";
    private static final String ELEMENT_FAILED = "totalfailed";
    private static final String ELEMENT_UNKNOWN = "totalunknown";
    private static final String ELEMENT_ERROR = "totalerror";
    private int myTotal;
    private int myPassed;
    private int myFailed;
    private int myUnknown;
    private int myError;
    private GenericTagAndStringXmlHandler myTotalXmlHandler;
    private GenericTagAndStringXmlHandler myPassedXmlHandler;
    private GenericTagAndStringXmlHandler myFailedXmlHandler;
    private GenericTagAndStringXmlHandler myUnknownXmlHandler;
    private GenericTagAndStringXmlHandler myErrorXmlHandler;

    public SummaryResultXmlHandler(XMLReader anXmlReader) {
        super(anXmlReader, ELEMENT_START);
        this.reset();
        this.myTotalXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_TOTAL);
        this.addElementHandler(ELEMENT_TOTAL, (XmlHandler)this.myTotalXmlHandler);
        this.myPassedXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_PASSED);
        this.addElementHandler(ELEMENT_PASSED, (XmlHandler)this.myPassedXmlHandler);
        this.myFailedXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_FAILED);
        this.addElementHandler(ELEMENT_FAILED, (XmlHandler)this.myFailedXmlHandler);
        this.myUnknownXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_UNKNOWN);
        this.addElementHandler(ELEMENT_UNKNOWN, (XmlHandler)this.myUnknownXmlHandler);
        this.myErrorXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_ERROR);
        this.addElementHandler(ELEMENT_ERROR, (XmlHandler)this.myErrorXmlHandler);
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        if (!aChildXmlHandler.getClass().equals(GenericTagAndStringXmlHandler.class)) {
            throw new Error("ChildXmlHandler (" + aChildXmlHandler.getClass().toString() + ") must be of type GenericTagAndStringXmlHandler");
        }
        GenericTagAndStringXmlHandler childXmlHandler = (GenericTagAndStringXmlHandler)aChildXmlHandler;
        int value = Integer.valueOf(childXmlHandler.getValue());
        aChildXmlHandler.reset();
        if (value < 0) {
            throw new Error(aQualifiedName + " can not be less than zero: " + value);
        }
        if (aQualifiedName.equalsIgnoreCase(ELEMENT_TOTAL)) {
            this.myTotal = value;
        } else if (aQualifiedName.equalsIgnoreCase(ELEMENT_PASSED)) {
            this.myPassed = value;
        } else if (aQualifiedName.equalsIgnoreCase(ELEMENT_FAILED)) {
            this.myFailed = value;
        } else if (aQualifiedName.equalsIgnoreCase(ELEMENT_UNKNOWN)) {
            this.myUnknown = value;
        } else if (aQualifiedName.equalsIgnoreCase(ELEMENT_ERROR)) {
            this.myError = value;
        }
    }

    public ResultSummary getSummary() {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        int unknown = this.myTotal - this.myPassed - this.myFailed - this.myError;
        if (unknown >= 0) {
            return new ResultSummary(this.myPassed, this.myFailed, unknown, this.myError);
        }
        return new ResultSummary(this.myPassed, this.myFailed, this.myUnknown, this.myError);
    }

    public void reset() {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        this.myTotal = 0;
        this.myPassed = 0;
        this.myFailed = 0;
        this.myUnknown = 0;
        this.myError = 0;
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void processElementAttributes(String qualifiedName, Attributes att) {
    }
}

