/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.io.File;
import java.io.IOError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.testtoolinterfaces.testresult.TestCaseResult;
import org.testtoolinterfaces.testresult.TestCaseResultLink;
import org.testtoolinterfaces.testresultinterface.TestCaseResultXmlHandler;
import org.testtoolinterfaces.testsuite.TestInterfaceList;
import org.testtoolinterfaces.utils.Trace;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLReader;

public class TestCaseResultReader {
    private TestInterfaceList myInterfaceList;

    public TestCaseResultReader(TestInterfaceList anInterfaceList) {
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.myInterfaceList = anInterfaceList;
    }

    public TestCaseResult readTcResultFile(TestCaseResultLink aTestCaseResultLink) {
        Trace.println((Trace.LEVEL)Trace.SUITE, (String)("readTcResultFile( " + aTestCaseResultLink.getId() + " )"), (boolean)true);
        return this.readTcResultFile(aTestCaseResultLink.getLink());
    }

    public TestCaseResult readTcResultFile(File aTestCaseResultFile) {
        TestCaseResult testCaseResult;
        Trace.println((Trace.LEVEL)Trace.SUITE, (String)("readTcResultFile( " + aTestCaseResultFile.getPath() + " )"), (boolean)true);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(false);
        try {
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            TestCaseResultXmlHandler handler = new TestCaseResultXmlHandler(xmlReader, this.myInterfaceList);
            xmlReader.setContentHandler((ContentHandler)((Object)handler));
            xmlReader.parse(aTestCaseResultFile.getAbsolutePath());
            testCaseResult = handler.getTestCaseResult();
        }
        catch (Exception e) {
            Trace.print((Trace.LEVEL)Trace.SUITE, (Throwable)e);
            throw new IOError(e);
        }
        return testCaseResult;
    }
}

